	page	,132

;-----------------------------------------------------------------------------
;
;  This file is part of doskey.com.
; 
;  Copyright (C) 2001-2011 Paul Houle (http://paulhoule.com)
; 
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
; 
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
; 
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
;
;  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; DOSKEY int 2fh handler.
;
;-----------------------------------------------------------------------------

	.nolist
	include	dkdefs.inc	;include constant definitions, externdef's
	.list
	option	noljmp		;disallow automatic jmp-lengthening

;-----------------------------------------------------------------------------

MyInt2f	proc	near
	cmp	ax,4b05h	;DOS task switch 'Identify instance data'?
	jz	axIdata
	cmp	ax,1605h	;Windows task-switch (get instance data)?
	jz	axIdata
	cmp	ah,48h		;DOSKEY multiplex interrupt?
	jz	ah48


Continue2f:
	jmp	cs:Old2fVector	;jmp= go to pre-installation int 2fh handler


ah48:				;DOSKEY int 2fh function
	test	al,al		;ax= 4800h?
	jz	ax4800h		;jmp= yes, DOSKEY installation check
	cmp	al,10h		;get DOSKEY command line call?
	jnz	Continue2f	;jmp= no, ignore

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Get command line function recognized.  Enable interrupts, set
	; forward direction, and save regs we'll modify.

	sti
	cld

	push	es			;generate ENTRYSTACKFRAME on stack
	push	ds			;these pushes must match (in reverse)
	push	dx			;  the order of ENTRYSTACKFRAME
	push	cx			;  definitions
	push	bx
	push	bp
	push	di
	push	si

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Disallow if user buffer is not sized correctly (we only support a
	; single size now).  The user recognizes the error by ax not being
	; zero (it is 4810h now).

	mov	si,dx
	.if	byte ptr [si] == IOBUF_SIZE ;if user buffer sized correctly,

	  ifdef	EBUG
	    .if	bx != 'de' || cx != 'ug'
	  endif
	      push cs			;set local es
	      pop  es
	  ifdef	EBUG
	    .endif
	  endif

		;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		; Transfer current stack frame to local storage (lowers total
		; stack requirements, provides access to entry registers).

	  push	ss			;copy stack frame to local storage
	  pop	ds
	  mov	si,sp
	  mov	di,offset EntryFrame
	  mov	cx,sizeof EntryFrame / 2
	  rep movsw
	  mov	sp,si			;discard frame from stack

		;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		; Call command line entry function, with ds = es = cs.

	  push	es			;set local ds (note: must copy from
	  pop	ds			;  es for debugging system to work)

	  call	GetCmdLine
	  xor	ax,ax			;indicate input line was returned

		;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		; Transfer copy of entry frame back to stack.

	  mov	si,offset EntryFrame
	  mov	cx,sizeof EntryFrame / 2
	  sub	sp,sizeof EntryFrame
	  push	ss
	  pop	es
	  mov	di,sp
	  rep movsw

	.endif

	pop	si
	pop	di
	pop	bp
	pop	bx
	pop	cx
	pop	dx
	pop	ds
	pop	es
	iret

ax4800h:			;DOSKEY installation check
	mov	ax,DOSKEY_ID
	.if	0
axIdata:			;get task switcher instance data list
	  pushf
	  push	cs
	  call	near ptr Continue2f
	  mov	word ptr cs:[SwStartup.sisNextDev + 0],bx
	  mov	word ptr cs:[SwStartup.sisNextDev + 2],es
	  mov	bx,offset SwStartup
	.endif
	push	cs
	pop	es
	iret
MyInt2f	endp

;-----------------------------------------------------------------------------
;
; End Module
;
;-----------------------------------------------------------------------------

	ENDSEG
	end
