	page	,132

;-----------------------------------------------------------------------------
;
;  This file is part of doskey.com.
; 
;  Copyright (C) 2001-2011 Paul Houle (http://paulhoule.com)
; 
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
; 
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
; 
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
;
;  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; DOSKEY tab completion logic.
;
;-----------------------------------------------------------------------------

	.nolist
	include	dkdefs.inc	;include constant definitions, externdef's
	.list
	option	noljmp		;disallow automatic jmp-lengthening

;-----------------------------------------------------------------------------

TabComplete proc near

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Get freespace for tab completion work area.  Set bx to point at
	; TABWORK for the duration of the completion logic.
	;
	; This allocation will cause the loss of the oldest 'sizeof TABWORK'
	; bytes of history.

	mov	cx,sizeof TABWORK + 1
	call	GetHistoryFreespace	;bx= get freespace for TABWORK
	mov	bx,di
	inc	bx			;put on word boundary for speed
	and	bl,not 1
	assume	bx:near ptr TABWORK
	mov	al,nolfn
	xor	al,1
	mov	[bx].LFN,al

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Save current DTA address on the stack, so we can set a new DTA.

	push	es
	push	bx
	mov	ah,2fh			;dx:ax= disk transfer address (DTA)
	int	21h
	xchg	ax,bx
	mov	dx,es
	pop	bx
	pop	es

	push	dx			;stack entry DTA for exit restoration
	push	ax

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Set DTA to our temporary find first/next buffer.

	lea	dx,[bx].Find1st		;set current DTA to find first buffer
	mov	ah,1ah
	int	21h

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Determine if an auto-completion will be allowed.  We'll only allow
	; if: 1) the cursor is not past the end of CmdBuf (if it is, there's
	; no room to insert even a single character); and 2) if the cursor
	; isn't at EOL, the character under the cursor must not be a valid
	; filename character (it must be a terminator of some sort).

	call	Get_cbCurrent_cbLast	;get cb pointers
	cmp	si,offset CmdBufLimit	;at absolute end of CmdBuf?
	jae	jmpTabAbort		;jmp= yes, disallow tab
	.if	si < di			;if a character is under the cursor,
	  mov	al,[si]			;al= char under cursor
	  call	IsPathChar		;zero status if al is file/path char
	  jz	jmpTabAbort		;jmp= can't tab, on file/path char
	.endif

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Isolate the partial path (preceding cursor) within the command
	; line:
	;
	;	.PathPtr/si= address of partial path
	;	.PathLength/cx= length of partial path (0-n)
	;
	; If the preceding path is too big for our find first buffer (less
	; the worst case wildcard amount we may need to append - '\*.*',0),
	; disallow the TAB.

	push	si			;save starting point
	.while	si > offset CmdBuf	;while more chars precede si,
	  mov	al,[si-1]		;al= preceding character
	  call	IsPathChar		;is it a file/path character?
	  .break .if !zero?		;break= no, found start of file/path
	  dec	si			;back up another character
	.endw
	pop	cx			;cx= count of preceding path chars
	sub	cx,si
;030121	.if	cx > sizeof TABWORK.FindBuf - 5	;if too big to process,
;030121	  jmp	TabCompleteAbort	;jmp= exit w/o additional keystrokes
;030121	.endif
	cmp	cx,sizeof TABWORK.FindBuf - 5	;too big to process?	;030121
	ja	jmpTabAbort		;jmp= yes, abort		;030121
	mov	[bx].PathPtr,si		;save mask start and size
	mov	[bx].PathLength,cx

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Isolate the name portion of the partial path (exclude any prepended
	; specific path - i.e., locate the trailing portion), and store its
	; length in .NameLength.  We'll need this info to know how many
	; characters to append when a match is found.
	;
	; If no path is prepended, .NameLength == .PathLength.

	mov	di,si			;di= 1 beyond last char in user path
	add	di,cx
	mov	dx,di			;init name length
	jcxz	@F			;jmp= no path specified in prefix

	  ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	  ; Check for and handle special case: if the final character(s) of
	  ; the user entry are a '.' or '..' directory indicator, simply add
	  ; a '\' to the entry and exit.  No searching of any kind is needed.

	  mov	al,[di-1]		;fetch last entered char
	  .if	al == '.'		;if may be '.' or '..' directory case,
	    dec	cx			;see if more chars
	    .if	!zero?			;if more chars precede,
	      mov al,[di-2]		;get char in front of the '.'
	    .endif
	    inc	cx			;undo above decrement
	    .if al != '.' && al != ':'	;set zero flag if definite directory
	      cmp al,'\'
	    .endif
	    .if	zero?			;if user specifying '.' or '..',
	      mov al,'\'		;always complete by appending '\'
	      call StoreCharInsertMode
	      jmpTabAbort:
	      jmp TabCompleteAbort	;jmp= exit w/o additional keystrokes
	    .endif
	  .endif

	  .repeat			;scan to see if a path is specified,
	    mov	al,[di-1]		;get previous char
	    .break .if al == ':' || al == '\' ;break= path indicator found
	    dec	di			;back up
	  .untilcxz			;continue if more partial path remains
	@@:
	sub	dx,di			;save length of final name portion
	mov	[bx].NameAddr,di
	mov	[bx].NameLength,dx

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; .Flags init.  If in argument area of command line:
	;
	;	Clear the TW_CMDVERB flag, so we won't restrict the type of
	;	files we'll match.
	;
	;	Clear the TW_PATHSEARCH flag.  This will prevent searching
	;	the system path.
	;
	; Otherwise (in command verb area of command line):
	;
	;	Set the TW_CMDVERB flag, to restrict the type of files we'll
	;	match to .BAT, .EXE and .COM.
	;
	;	If a path is present in the user's entry, clear the
	;	TW_PATHSEARCH flag so we won't search the system path;
	;	otherwise, set TW_PATHSEARCH.

	mov	ah,0			;assume we're in the argument area
	.repeat				;loop to scan in front of prefix,
	  mov	al,CMDSEP		;assume at start of line
	  .break .if si == offset CmdBuf ;break= assumption correct
	  dec	si			;else back up and load prev character
	  mov	al,[si]
	  mov	di,offset CommandPrefix	;char allowed to prefix a command?
	  mov	cx,offset CommandPrefixLast + 1
	  sub	cx,di
	  repne scasb
	.until !zero?			;skip allowable command prefix chars
	.if al == CMDSEP || al == '|'	;if in command verb area,
	  mov	ah,TW_CMDVERB		;restrict type of file we'll match
	  mov	cx,[bx].NameLength	;if path not present in user entry,
	  .if	cx == [bx].PathLength	;  allow search of system path
	    mov	ah,TW_CMDVERB or TW_PATHSEARCH
	  .endif
	.endif
	mov	[bx].Flags,ah		;store initialized .Flags image

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Main loops.  The outer loop is so we can restart the scan, and
	; skip over entries to a selected point (used to back up via a
	; shift+tab).  The inner loop is for advancing in the list via
	; the tab key.

	xor	cx,cx			;start with skip mode off
	mov	[bx].CharsInserted,cx	;(and no chars inserted)
;030121 .while	1			;loop for backing up,
      .repeat				;loop for backing up,		;030121
	mov	[bx].SkipTo,cx		;install skip count
	and	[bx].TotalDone,0	;initialize count of found names
	or	[bx].Flags,TW_INIT	;cause search initialization to occur
	.repeat				;loop to fetch next name
	  @@:
	  call	TabNextName		;attempt to get the next name
	  mov	cx,[bx].TotalDone	;total names loaded so far
	  jcxz	TabCompleteAbort	;jmp= no names match, exit tab mode
	  .if	!zero?			;if a name was acquired,
	    cmp	cx,[bx].SkipTo		;should this entry be skipped?
	    jb	@B			;jmp= yes, skip it

	    ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	    ; Insert completion string into CmdBuf.  We only insert that
	    ; portion of the name beyond what the user has already typed; and
	    ; then we add a '\' or ' ' to the end.  Note we must be careful:
	    ; the found name may actually be shorter than the prefix string
	    ; entered (e.g., prefix "foo." will match "foo"); so we only limit
	    ; our skipping in the found name to what's really there.

	    call TabRemove		;first remove any previous completion

	    call Get_cbCurrent_cbLast	;save cursor startpoint
	    push si
	    call GetFiFileName
	    .repeat			;limit skip to what exists in match
	      inc si
	    .untilcxz byte ptr [si] == 0
	    call StoreStringInsertMode	;insert string into CmdBuf
	    mov	al,' '			;assume file, add a trailing blank
	    .if	[bx].LFN && [bx].Find1stL.fiAttribute & ATTR_DIRECTORY || ![bx].LFN && [bx].Find1st.fiAttribute & ATTR_DIRECTORY ;if dir name,
	      mov  al,'\'		;insert a final '\' instead
	    .endif
	    call StoreCharInsertMode
	    call Get_cbCurrent_cbLast	;get cursor endpoint
;030121	    mov	cx,si			;cx= count of char(s) inserted
;030121	    pop	si
;030121	    sub	cx,si
;030121	    mov	[bx].CharsInserted,cx	;save new count of inserted chars
	    pop	di			;si= count of inserted chars	;030121
	    sub si,di							;030121
	    mov	[bx].CharsInserted,si	;save count of inserted chars	;030121
	  .endif

	  call	GetKeybCharNoEcho	;get next user keystroke
	.until	ax != TAB		;loop if tabbing to next match

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; If not shift+tab, exit tab mode.

	cmp	ax,100h + SHFTAB	;shift+tab?
	jnz	TabCompleteExit		;jmp= no, exit (process externally)

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Shift+tab - back up to the previously inserted name.  If we're
	; at the start of the list, "back up" to an empty entry (done by
	; simply exiting, after removing the previous insertion).
	; Note we don't keep a list of the completions, so the only way to
	; back up is to restart the scan and skip to where we want to be.

	call	TabRemove		;remove previous completion
	mov	cx,[bx].TotalDone	;count of name(s) acquired
	dec	cx			;count needed if we back up one
;030121	jz	TabCompleteAbort	;jmp= backing out of list altogether
;030121 .endw				;loop to restart scan to back up
      .until	zero?			;loop if another exists in list	;030121

TabCompleteAbort:
	mov	ax,LF			;note: linefeed is defined to be NOP

TabCompleteExit:

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; 030121 Start of fix: If the completion session ended with a CR,
	;	remove a trailing backslash, if one is present at the end of
	;	what was added.  This makes the 16-bit CD, RD & COPY commands
	;	happy -- they disallow a trailing backslash on a dir name.
	; 030926 Extended above to include a space, so commands like
	;	REN dir newdir or COPY dir otherdir work better when source
	;	is a directory name (they disallow a trailing '\').

;030926	.if	ax == CR		;if tab session was ended w/a CR,
	.if	ax == CR || ax == ' '	;if ended w/CR or space,	;030926
	  mov	cx,[bx].CharsInserted	;chars we inserted above (if any)
	  jcxz	@F			;if we inserted something,
	    call Get_cbCurrent_cbLast	;si= 1 beyond last inserted char
	    .if	byte ptr [si-1] == '\'	;if final char was a backslash,
	      .if !([bx].Flags & TW_CMDVERB) ;and not in verb portion of line,
		push ax
		call BackSpace		;remove it
		pop ax
	      .endif
	    .endif
	  @@:
	.endif

	jmp ToNext

GetFiFileName:
	mov cx,[bx].NameLength	;cx= user-entered chars to skip over
	.if [bx].LFN
	  lea si,[bx].Find1stL.fiFileName ;si= start of matched name
	  mov di,[bx].NameAddr
	  mov bp,cx
	  push si
	  push di
	  .repeat
	    dec bp
	    mov al,[si]
	    call ToLower
	    mov ah,al
	    mov al,[di]
	    call ToLower
	    .if ah != al
	      mov [bx].NameAddr,0
	     .break
	    .endif
	    inc si
	    inc di
	  .until bp == 0
	  pop di
	  pop si
	  push di
	  .if ([bx].NameAddr == 0)
	    lea si,[bx].Find1stL.fiSFileName
	    mov bp,cx
	    .repeat
	      dec bp
	      mov al,[si]
	      call ToLower
	      mov ah,al
	      mov al,[di]
	      call ToLower
	      .if ah != al
	        mov [bx].NameAddr,-1
	       .break
	      .endif
	      inc si
	      inc di
	    .until bp == 0
	    .if ([bx].NameAddr == 0)
	      lea si,[bx].Find1stL.fiSFileName ;try to use SFN if user input matches SFN instead of LFN
	    .else                              ;e.g. WINDOW~1 instead of WINDOWSSETUP even if LFN is available
	      lea si,[bx].Find1stL.fiFileName
	    .endif
	  .endif
	  pop di
	  mov [bx].NameAddr,di
	.else
	  lea si,[bx].Find1st.fiFileName ;si= start of matched name
	.endif
	 dec	si			;compensate for 1st loop
	 inc	cx
	 ret
	
ToNext:
	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; 030121 End of fix

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Restore entry DTA.

	pop	dx			;bx:dx= DTA saved on entry
	pop	bx

	push	ax
	push	ds
	mov	ds,bx			;restore entry DTA
	mov	ah,1ah
	int	21h
	pop	ds
	pop	ax

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Exit - ax will hold keystroke that caused us to exit TAB mode (or
	; a zero, which is ignored by the keystroke dispatcher).

	jmp	DispatchKeystroke	;dispatch char that ended completion

TabComplete	endp

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Removes a previous completion (if any) from the command line buffer.

TabRemove proc near
	xor	cx,cx			;fetch/clear count of inserted chars
	xchg	cx,[bx].CharsInserted
	push	bx			;remove char(s) from CmdBuf
	push	cx
	call	BackupCxChars
	pop	cx
	call	DeleteCxChars
	pop	bx
	ret
TabRemove endp

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Acquires next matching file/directory entry for completion.  If successful,
; the acquired name is left in the TABWORK.Find1st work area.
;
; IN:
;   bx= TABWORK area base address
;
; OUT:
;   [bx].Find1st= holds find first/find next result, if new name acquired
;   [bx].TotalDone= incremented, if a new name is acquired
;   zero status if another name could not be acquired (i.e., end of list)

TabNextName proc near; fhandle:word

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; If first search:
	;
	; If the user has not entered a specific path, we'll need the
	; .NextPathPtr to point to potential directories to search.  If we're
	; in the command verb area, point it to the system path; otherwise,
	; point it to an empty list, to include only the current directory.
	;
	; Also set the carry if this is the first search, to cause the find
	; performed below to be a find first instead of a find next.

	mov	al,[bx].Flags		;load flags image
	test	al,TW_INIT		;clear carry, nz if need to init
	.if	!zero?			;if need to init,
	  push	es
;030121	  push	di
	  mov	di,offset SingleZero	;assume current dir search only
	  and	al,TW_CMDVERB or TW_PATHSEARCH	;isolate path search flags
	  .if	al == TW_CMDVERB or TW_PATHSEARCH ;if path search required,
	    push bx
	    mov  ah,51h			;bx= current PSP segment
	    int  21h
	    mov  es,bx			;es:di= environment block
	    mov  es,es:[ENV_OFFSET]
	    xor  di,di
	    mov  si,offset PathEquals	;search environment for path=
	    call StringListPoolSearch
	    pop  bx
	  .endif
	  mov	word ptr [bx].NextPathPtr,di ;set potential path search list
	  mov	word ptr [bx].NextPathPtr+2,es
;030121	  pop  di
	  pop  es
	  stc				;insure carry is set for below
	.endif

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Execute find first/find next (if carry is set entering here, we do
	; a find first; otherwise, we do a find next.
	;
	; Note: normally we search for all matching files and directories;
	; however, we exclude directories if we're searching a directory
	; from the path (which means the current directory has already been
	; searched).

FindFirstNext:
	.repeat				;loop to scan directory(ies),
	  mov	cx,ATTR_DIRECTORY	;default to find files and directories
	  .if	carry?
	    .if	!([bx].Flags & TW_INIT)	;if current dir already searched,
	      xor cx,cx			;exclude directories from search
	    .endif
	    push cx			;save find attribute mask
	    call TabBuildFullPath	;build find first mask
	    pop cx
	    jz	TabNextRet		;jmp= no more - exit w/zero status
	     lea dx,[bx].FindBuf
	    .if [bx].LFN		;if LFN API is available
	      lea di,[bx].Find1stL
	      mov ax,714eh		;find first
	      push cx
	      mov si,1
	      int 21h			;perform find first/next
	      pop cx
	    .else
	      lea di,[bx].Find1st
	      mov ax,7100h
	    .endif
	    pushf
	    .if ax == 7100h
	    	popf
	    	mov [bx].LFN,0		;try SFN counterpart
	    	mov ax,4e00h
	    	int 21h
	    .else
	    	mov [bx].FHandle,ax
	    	popf
	    .endif
	  .else
	    lea	dx,[bx].FindBuf
	    push bx
	    .if [bx].LFN		;if LFN API is available
	   	mov ax,714fh		;find next
	   	lea di,[bx].Find1stL
	   	mov bx,[bx].FHandle
	   	mov si,1
	    .else
	   	mov ax,4f00h
	   	lea di,[bx].Find1st
	    .endif
	    int	21h			;perform find first/next
	    pop bx
	    .if carry?
	      .if [bx].LFN
	   	call CloseHandle
	      .endif
	    stc
	    .endif
	  .endif
	.until	!carry?			;loop if time to try next directory
	jmp nextLoc

TabNextRet:
ret

CloseHandle:
push bx
mov bx,[bx].FHandle
mov ax,71a1h
int 21h
pop bx
ret

@@:
jmp FindFirstNext

nextLoc:
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Ignore the '.' and '..' entries.  These names are completed with
	; special logic (they are never searched for).

	.if [bx].LFN
	  lea	di,[bx].Find1stL.fiFileName ;di= ptr to start of found name
	.else
	  lea	di,[bx].Find1st.fiFileName
	.endif
	mov	si,di			;ignore '.' and '..'
	.repeat				;dummy block (to support breaks)
	  lodsb				;set zero status if '.' or '..' entry
	  .break .if al != '.'
	  lodsw
	  .break .if al == 0
	  cmp ax,'.'
	.until 1			;end dummy block (to support breaks)
	jz	@B			;jmp= '.' or '..' entry, ignore

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; 011212: (got tired of uppercase).  Converted find buffer chars to
	; lowercase, in-place.

	mov	dx,di			;save for extension check (to follow)
	.repeat				;convert result to lowercase, in-place
	  mov	al,[di]
	  ;call	ToLower			;disabled for LFN support
	  stosb
        .until  al == 0

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; If performing a command completion, only allow files with
	; appropriate extensions (but allow directories of any name).

	.if	[bx].Flags & TW_CMDVERB	;if command completion,
	  .if	!([bx].LFN && [bx].Find1stL.fiAttribute & ATTR_DIRECTORY || ![bx].LFN && [bx].Find1st.fiAttribute & ATTR_DIRECTORY) ;if not a dir,
;011212	    mov	ch,255			;scan to end of file/dir name
;011212	    mov	al,0
;011212	    mov	dx,di			;(save start of asciiz name)
;011212	    repne scasb
	    lea	si,[di-5]		;si= start of suspected .com/.bat/.exe
	    sub	dx,si			;carry clear= backed up too far
	    jnc	@B			;jmp= invalid completion, ignore it
	    mov	di,offset CommandExts	;search for valid command .ext
	    call StringListPoolSearch
	    clc				;assume extension not found
	    jnz	@B			;jmp= invalid extension, ignore
	  .endif
	.endif

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Increment count of successfully found names.  Note this also sets
	; a non-zero return status, which indicates a new name was found.

	inc	[bx].TotalDone		;bump count of returned names

ret
TabNextName endp

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Builds the next full path mask in [bx].FindBuf.
;
; The full path mask is built from the next path entry (if searching the
; path) and the user command-line filespec (appropriately extended with
; wildcards, if necessary).
;
; IN:
;   bx= TABWORK area base address
;
; OUT:
;   [bx].FindBuf= holds ASCIIZ path math
;   zero status if another path could not be built

STOSB_IF_CX macro		;executes <stosb, dec cx> if cx is non-zero
	local	cxzero
	jcxz	cxzero
	  stosb
	  dec	cx
	cxzero:
	endm

TabBuildFullPath proc near

      .repeat				;loop in case we overflow our buffer

	lea	di,[bx].FindBuf		;build path here
	mov	cx,sizeof TABWORK.FindBuf ;max path length
	.if	!([bx].Flags & TW_INIT)	;if this is not the first path,

	  ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	  ; Move the .NextPathPtr entry to the start of the mask buffer.

	  push	ds
	  lds	si,[bx].NextPathPtr	;ds:si= pointer to next path to use
	  .repeat			;skip leading whitespace or ';' chars
	    call SkipWhitespace
	    inc  si			;assume we've hit a ';'
	  .until al != ';'		;loop if assumption correct
	  dec	si			;undo 1 too many advances
	  .while al != 0 && al != ';'	;while haven't hit entry terminator,
	    inc	si			;consume the character
	    STOSB_IF_CX			;stosb and dec cx, if cx is non-zero
	    call SkipWhitespace		;ignore any whitespace
	  .endw
	  pop	ds			;update next path ptr
	  mov	word ptr [bx].NextPathPtr,si

	  cmp	cx,sizeof TABWORK.FindBuf ;was a path available to move in?
	  .break .if zero?		;break= no, exit w/zero status

	  ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	  ; Unless there's already one there, append a '\' to end of path
	  ; entry we just moved in.

	  mov	al,'\'			;char of interest
	  dec	di			;compare vs. last one stored
	  scasb
	  .if	!zero?			;if last char was not a '\',
	    STOSB_IF_CX			;stosb and dec cx, if cx is non-zero
	  .endif
	.endif

	and	[bx].Flags,not TW_INIT	;indicate initialization phase done

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Append the user's partial path characters.

	mov	si,[bx].PathPtr		;si/dx= user path start and size
	mov	dx,[bx].PathLength
	.while	dx != 0			;while more to append,
	  lodsb				;get next user path char
	  dec	dx
	  STOSB_IF_CX			;stosb and dec cx, if cx is non-zero
	.endw

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Now extend the user's partial path with wildcard characters, as
	; necessary (e.g., if the user's entry ends with "*.*" there's
	; nothing to add; but if it ends with "xyz" then "*.*" is added; or
	; if it ends with "xy*." a single "*" is added).

	push	cx			;save remaining mask buffer space
	call SupBreak
	pop	cx			;restore remaining mask buffer space
	mov	si,dx			;si= ASCIIZ wildcard string to append
	.repeat				;append wildcard mask
	  lodsb
	  STOSB_IF_CX			;stosb and dec cx, if cx is non-zero
	.until	al == 0

	test	cx,cx			;zero status if path was unacceptable
      .until	!zero?			;loop if path was unacceptable

	ret
	
SupBreak:
.repeat				;dummy block (to support breaks)
	mov	dx,offset StarDotStar	;assume we'll append full '*.*'
	mov	cx,[bx].PathLength	;si/cx= end+1/size-of user entry
	jcxz	@F			;jmp= user entry empty, append '*.*'
	.repeat			;scan for '.' before ':' or '\'
	dec	si			;al= preceding char
	mov	al,[si]
	.break .if al == ':'	;break= ':', append '*.*'
	.break .if al == '\'	;break= '\', append '*.*'
	.if	al == '.'		;if filename separator ('.') found,
	inc dx			;discard leading '*.' portion
	inc dx
	.break
	.endif
	.untilcxz			;continue scanning if chars remain
	@@:
.until 1			;end dummy block (to support breaks)
ret

TabBuildFullPath endp

;-----------------------------------------------------------------------------
;
; End Module
;
;-----------------------------------------------------------------------------

	ENDSEG
	end
