;-----------------------------------------------------------------------------
;
;  This file is part of doskey.com.
; 
;  Copyright (C) 2001-2011 Paul Houle (http://paulhoule.com)
; 
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
; 
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
; 
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
;
;  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; ***	Start of dkdefs.inc: doskey definitions  ***
;
; ***	Publics are EXTERNDEF'd at the bottom of this module  ***
;
;-----------------------------------------------------------------------------

	ifdef	EBUG
	  echo	**********  Warning - debug build  **********
	endif

	.8086			;allow only 8086 opcodes

;-----------------------------------------------------------------------------
;
; Constant defintions.
;
;-----------------------------------------------------------------------------

DOSKEY_ID equ	0ABC3h			;int 2fh, 4800h  DOSKEY installed ID

IOBUFSIZE_MAX	equ	255		;maximum size of caller's command buffer
IOBUFSIZE_MIN	equ	128		;minimum size of caller's command buffer

DEFAULT_BUFSIZE	equ	800		;default mem allocated for history/macro space
BUFSIZE_MIN	equ	600		;bufsize may not be smaller than this
HISTORY_MIN	equ	(IOBUFSIZE_MAX * 2 + 50)	;room for at least 1 command line
MACROS_MAX	equ	(IOBUFSIZE_MIN + 2)		;room for at least 1 macro row

CR	equ	0dh
LF	equ	0ah
TAB	equ	09h
BS	equ	08h
CTL_Z	equ	1ah
ESCAPE	equ	1bh
CTL_F	equ	06h

SHFTAB	equ	15
CTRLTAB	equ	148
ALTF11	equ	139
ALTF10	equ	113
ALTF9	equ	112
ALTF8	equ	111
ALTF7	equ	110
ALTF6	equ	109
ALTF5	equ	108
RIGHT	equ	77
LEFT	equ	75
PAGEUP	equ	73
PAGEDOWN equ	81
F12	equ	134
F11	equ	133
F10	equ	68
F9	equ	67
F8	equ	66
F7	equ	65
F6	equ	64
F5	equ	63
F4	equ	62
F3	equ	61
F2	equ	60
F1	equ	59
CTLRIGHT equ	116
CTLLEFT equ	115
CTLHOME	equ	119
CTLEND	equ	117
DEL	equ	83
INSKEY	equ	82
HOME	equ	71
ENDKEY	equ	79
DOWN	equ	80
UP	equ	72

CMDSEP	equ	14h	;CTL<T>	;macro command separator
CMDUNK	equ	15h	;CTL<U>	;unknown - reserved mapping char?

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; The low order 8 of the below flag bits are stored in tflags.
	; The TF_ flags are definitions that occur within the resident
	; code.  The GF_ flags occur in the startup code.  The startup code
	; uses TF_ definitions where flags that stay resident after
	; installation (e.g., TF_/GF_ INSERT) are modified; the mask for
	; these flags is TF_RESIDENTFLAGS.
	;
	; The upper order flags are defined during startup only, and are
	; never stored (they are maintained in a register).  Resident flags,
	; when changed by a command line switch, have a 1 bit set in the
	; same position of the upper flags to indicate a change is required
	; to a resident image (if a resident image is modified).

		;tflags bits

  GF_ERROR	equ	1	;force exit w/non-zero errorlevel
TF_EXIT		equ	2	;force keystroke dispatcher exit
  GF_EXIT	equ	2	;force early exit w/message
TF_INSERT	equ	4	;currently active insert mode
  GF_HISTORY	equ	4	;Flags: /HISTORY selected
  GF_MACROS	equ	8	;Flags: /MACROS selected
  GF_REINSTALL	equ	10h	;/REINSTALL selected
  GF_LFN	equ	20h	;/ENABLELFN selected
  GF_NOLFN	equ	40h	;/DISABLELFN selected
TF_STARTINSERT	equ	80h	;start of line input insert state
  GF_BUFSIZE	equ	100h	;/BUFSIZE selected
  GF_VERBOSE	equ	200h	;/VERBOSE selected
  ifdef	EBUG
    GF_GETINPUT	equ	200h	;DEBUG: simulate int 2fh Get Input Line
  endif
  GF_APPEND	equ	400h	;/APPENDMODE selected
  GF_CHANGE	equ	800h	;/CHANGEMODE selected
  GF_NOSYSHIDDEN equ	1000h	;/NOSYSTEMFILES selected
  GF_SYSHIDDEN	equ	2000h	;/SYSTEMFILES selected
CM_NOLFN	equ	1
CM_CHANGE	equ	2
CM_SYSHIDDEN	equ	4
TF_STARTINSERT_CHANGE	equ (TF_STARTINSERT shl 8)

TF_RESIDENTFLAGS equ	(TF_STARTINSERT)

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; An image of the stack frame on entry, along with all registers we
	; save, is below.  We move the frame from the stack to local memory,
	; and restore it on exit.  This is done for two reasons:
	;
	;	1) (the primary one).  This limits the stack overhead we
	;	   require by the size of the below structure (a considerable
	;	   amount).
	;
	;	2) Having the image in local memory gives us easy access
	;	   to parameter(s) passed in registers at entry.
	;
	; This is only done when a command line processing call is issued.
	; Note this causes operation not to be re-entrant - but it isn't
	; anyway, since we utilize static variables within the segment.

ENTRYSTACKFRAME struc
  rsi		dw	?
  rdi		dw	?
  rbp		dw	?
  rbx		dw	?
  rcx		dw	?
  TemplatePtr	dd	?	;entry dx:ds stored here
  ses		dw	?
  fret		dd	?
  flags 	dw	?
ENTRYSTACKFRAME ends

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Screen information.  Notes:
	;
	;    1)	The current column value is always updated - when it equals
	;	the line length (.Cols), it is reset to zero.
	;
	;    2)	The current row value is also always updated.  If scrolling
	;	up occurs (scrolling down is impossible), it is pegged at the
	;	max (.Rows - 1), since in this case the actual row position
	;	is unchanged.
	;
	;    3) If scrolling occurs (again, only up is possible), the entry
	;	row value is decremented, since the actual row startpoint
	;	has moved.  If this goes negative, it is pegged at zero
	;	(once it hits to top screen row, it can move no further).
	;
	;    4)	The 'Col(s)' values must precede the 'Row(s)' values; we in
	;	places treat them together as a word.

SCREENINFO struc
  CurrentCol	db	?	;current screen column	
  CurrentRow	db	?	;current screen row
  EntryCol	db	?	;entry screen cursor column (0-n)
  EntryRow	db	?	;entry screen cursor row    (0-n)
  EntryMode	dw	?	;entry screen cursor mode (start, end)
  TotalCols	db	?	;total screen columns
  TotalRows	db	?	;total screen rows
SCREENINFO ends


STRINGLIST struc
  Head		dw	?		;start of list memory/first entry
  Active	dw	?		;addr of "active" list item
  Tail		dw	?		;addr of list terminating zero
  Next		dw	?		;addr beyond end of list memory
STRINGLIST ends

BIOS_SHIFT_STATUS equ	417h
ENV_OFFSET equ	2ch		;environment offset within PSP
SS_INSERT	equ	80h	;shift status byte insert mode flag

VIDEO_ROWS equ	484h

STDIN	equ	0
STDOUT	equ	1
STDERR	equ	2
STDAUX	equ	3
STDPRN	equ	4

ATTR_SYSHIDDEN	equ	6h	;system and hidden attributes
ATTR_DIRECTORY	equ	10h	;directory attribute

DISPLAYMODE struc
  dmInfoLevel	db	?
  dmReserved1	db	?
  dmDataLength	dw	?
  dmFlags	dw	?
  dmMode	db	?
  dmReserved2	db	?
  dmColors	dw	?
  dmWidth	dw	?
  dmLength	dw	?
  dmColumns	dw 	?
  dmRows	dw	?
DISPLAYMODE ends

PSP	struc	;lays out Program Segment Prefix
  pspInt20h		dw	?
  pspNextParagraph	dw	?
  pspReserved1		db	?		;reserved
  pspDispatcher		db	5 dup (?)
  pspTerminateVector	dd	?
  pspControlCVector	dd	?
  pspCritErrorVector	dd	?
  pspReserved2		dw	11 dup (?)	;reserved
  pspEnvironment	dw	?
  pspReserved3		dw	23 dup (?)	;reserved
  pspFCB_1		db	16 dup (?)
  pspFCB_2		db	16 dup (?)
  pspReserved4		dd	?		;reserved
  pspCommandTail	db	256 dup (?)
PSP	ends

FILEINFO struc		;find first/find next structure
  fiReserved	db	21 dup(?)	;reserved
  fiAttribute	db	?		;attribute of entry
  fiFileTime	dw	?		;time of last write
  fiFileDate	dw	?		;date of last write
  fiSize	dd	?		;file size
  fiFileName	db	13 dup(?)	;entry name and extension
FILEINFO ends

FILEINFOL struct
  fiAttribute	dw	?
  fiReserved	db	42 dup(?)
  fiFileName	db	260 dup(?)
  fiSFileName	db	14 dup(?)
FILEINFOL ends

SWINSTANCEITEM	struc	;Task switcher instance data descriptor list
  iisPtr	 dd	?	;points to the instance data
  iisSize	 dw	?	;size of instance data, in bytes
SWINSTANCEITEM	ends

SWSTARTUPINFO	struc	;Task switcher startup info structure
  sisVersion	 dw	?
  sisNextDev	 dd	?
  sisVirtDevFile dd	?
  sisReferenceData dd	?
  sisInstanceData dd	?
SWSTARTUPINFO	ends

TABWORK		struc	;Tab completion temporary work area
  Flags		db	?	;various flags (see below)
  NextPathPtr	dd	?
  NameLength	dw	?
  NameStr	db 256 dup (?)
  PathPtr	dw	?
  PathLength	dw	?
  CharsInserted	dw	?	;chars inserted from previous completion (0-n)
  TotalDone	dw	?	;total completions tabbed over so far
  SkipTo	dw	?	;skip to this completion count (to back up)
  FindBuf	db 258 dup (?)	;find first filename mask buffer
  FHandle	dw	?
  LFN		db	?
  lmode		db	?
  SFNQuote	db	?
TABWORK		ends
TW_INIT		equ	 1h	;initialize search: set prior to first search
TW_PATHSEARCH	equ	 2h	;include current dir/system path in search
TW_CMDVERB	equ	 4h	;in verb area of command line
.errnz	sizeof TABWORK gt HISTORY_MIN - 2, <TABWORK doesn't fit in history>

;-----------------------------------------------------------------------------
;
; Opcode skipping macros.  These generate essentially 1-byte forward short
; jumps of 1 or 2 bytes, by generating the appropriate "cmp ax/al,immed"
; opcode.  This can save a byte over using a short jump, if you don't care
; about the flags.
;
;-----------------------------------------------------------------------------

skip	macro
	nop;;			any 1 byte (gets replaced by endskip)
SkipFrom = $
	endm
endskip	macro
SkipSize = $ - SkipFrom
	org  SkipFrom - 1
	if	SkipSize gt 2
	  .err	<Invalid (too large) skip/endskip block>
	elseif	SkipSize eq 1
	  db	03ch;;		1-byte "cmp al,immed"
	else
	  db	03dh;;		2-byte "cmp ax,immed"
	endif
	org	$ + SkipSize
	endm

;-----------------------------------------------------------------------------
;
; Linker-related: declare externals, open segment, set assumes, and declare
; a macro that will be used to close the segment.
;
;-----------------------------------------------------------------------------

	assume ss:nothing
	assume ds:_TEXT, es:_TEXT
	assume cs:nothing
_TEXT	segment	byte public 'CODE'
ENDSEG	macro
@CurSeg	ends
	endm

	externdef Old2fVector:dword
	externdef CmdBuf:byte, CmdBufLen:byte
	externdef slMacros:STRINGLIST, slHistory:STRINGLIST
	externdef SwiData0:SWINSTANCEITEM, SwiData1:SWINSTANCEITEM
	externdef SwStartup:SWSTARTUPINFO
	externdef EntryFrame:ENTRYSTACKFRAME
	externdef scInfo:SCREENINFO
	externdef cmode:byte
	externdef tflags:byte
	externdef IOBufSize:word
	externdef CmdLineLimit:word
	externdef SingleZero:byte
	externdef StarDotStar:byte
	externdef CommandPrefix:byte
	externdef PathEquals:byte
	externdef CommandExts:byte
	externdef InvalidMacroDefMsg:byte
	externdef MoreMsg:byte
	externdef DirCmds:byte

	externdef Startup:near
	externdef QueryClose:near					;090612
	externdef GetCmdLine:near
	externdef IsWhitespace:near
	externdef SkipWhitespace:near
	externdef SkipSpaceTab:near
	externdef StringListAppend:near
	externdef Get_cbCurrent_cbLast:near
	externdef Set_cbCurrent_cbLast:near
	externdef cbActiveDisable:near
	externdef IsPathChar:near
	externdef IsLFNPathChar:near
	externdef IsLFNQuoteChar:near
	externdef DispatchKeystroke:near
	externdef StoreCharInsertMode:near
	externdef StoreStringInsertMode:near
	externdef BackSpace:near					;030121
	externdef BackupCxChars:near
	externdef DeleteCxChars:near
	externdef DeleteAll:near
	externdef ForwardChar:near
	externdef GetKeybCharNoEcho:near

	externdef MyInt2f:near

	externdef TabComplete:near
	externdef TabStart:near

	externdef OverwriteFormattedMsg:near
	externdef OverwriteFormattedMsgAl:near
	externdef SyncCursor:near
	externdef DisplayFormattedMsg:near
	externdef DisplayFormatted:near
	externdef DisplayFormattedMsgVirtual:near
	externdef DisplayFormattedVirtual:near
	externdef DisplayFormattedAl:near
	externdef DisplayCRLF:near
	externdef DisplayCRLFVirtual:near
	externdef OutputCRLF:near
	externdef OutputAl:near

	externdef StringListGetFreespace:near
	externdef GetHistoryFreespace:near
	externdef StringListAppend:near
	externdef StringListClear:near
	externdef StringListPoolSearch:near

	externdef EndResident:near
	externdef InstallTSR:near
	externdef InstallStackBase:near

	externdef ToLower:near,EndLastLines:near
	externdef CheckSBChar:near,CheckDBCSChar:near
	externdef CheckMacro:near,IsMacroNameChar:near
	externdef ParseMacroDef:near,ProcessMacro:near
	externdef GetMacroDefinitionInfo:near

;-----------------------------------------------------------------------------
;
;  ***  End of dkdefs.inc: doskey definitions  ***
;
;-----------------------------------------------------------------------------
