	page	,132

;-----------------------------------------------------------------------------
;
;  This file is part of doskey.com.
; 
;  Copyright (C) 2001-2011 Paul Houle (http://paulhoule.com)
; 
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
; 
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
; 
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
;
;  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; DOSKEY tab completion logic.
;
;-----------------------------------------------------------------------------

	.nolist
	include	dkdefs.inc	;include constant definitions, externdef's
	.list
	option	noljmp		;disallow automatic jmp-lengthening

Find1st		FILEINFO <>	;find first/next work area (43 bytes)
Find1stL	FILEINFOL <>	;find first/next work area (LFN version)

;-----------------------------------------------------------------------------

TabComplete proc near

	xor bp,bp
TabStart label near

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Get freespace for tab completion work area.  Set bx to point at
	; TABWORK for the duration of the completion logic.
	;
	; This allocation will cause the loss of the oldest 'sizeof TABWORK'
	; bytes of history.

	mov	cx,sizeof TABWORK + 1
	call	GetHistoryFreespace	;bx= get freespace for TABWORK
	mov	bx,di
	inc	bx			;put on word boundary for speed
	and	bl,not 1
	assume	bx:near ptr TABWORK
	mov	[bx].LFN,1
	.if cmode & CM_NOLFN
	  dec [bx].LFN
	.endif
	mov	[bx].lmode,0
	.if bp == -1
	  inc bp
	  inc [bx].lmode
	.endif
	push	bx
	mov	[bx].SFNQuote,0
	mov	ah,30h
	int	21h
	pop	bx
	.if al >= 7
	  inc [bx].SFNQuote
	.endif

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Save current DTA address on the stack, so we can set a new DTA.

	push	es
	push	bx
	mov	ah,2fh			;dx:ax= disk transfer address (DTA)
	int	21h
	xchg	ax,bx
	mov	dx,es
	pop	bx
	pop	es

	push	dx			;stack entry DTA for exit restoration
	push	ax

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Set DTA to our temporary find first/next buffer.

	lea	dx,Find1st		;set current DTA to find first buffer
	mov	ah,1ah
	int	21h

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Determine if an auto-completion will be allowed.  We'll only allow
	; if: 1) the cursor is not past the end of CmdBuf (if it is, there's
	; no room to insert even a single character); and 2) if the cursor
	; isn't at EOL, the character under the cursor must not be a valid
	; filename character (it must be a terminator of some sort).
	@@:
	call	Get_cbCurrent_cbLast	;get cb pointers
	.if [bx].LFN
	  push ax
	  push bx
	  mov ax,71A7h
	  xor bx,bx
	  int 21h
	  pop bx
	  .if ax == 7100h
	    mov [bx].LFN,0
	  .endif
	  pop ax
	.endif
	.if ([bx].LFN || [bx].SFNQuote) && cmode & CM_CHANGE && si > offset CmdBuf + 1
	  call ChangeQuotes
	.endif
	.if si >= CmdLineLimit		;reach the end of CmdBuf?
	  jmp	TabCompleteAbort	;jmp= yes, disallow tab
	.endif
	.if	si < di			;if a character is under the cursor,
	  mov	al,[si]			;al= char under cursor
	  call	ArePathChars		;zero status if al is file/path char
	  pushf
	  .if zero? && !([bx].LFN || [bx].SFNQuote) || al == '"' && ([bx].LFN || [bx].SFNQuote)
	    popf
	    jmp TabCompleteAbort
	  .endif
	  popf
	  .if zero?
	    call IsLFNQuoteChar
	    .if !zero?
	      call CheckQuotes
	      .if !zero?
	        jmp TabCompleteAbort
	      .endif
	    .else
	      jmp TabCompleteAbort
	    .endif
	  .endif
	.endif
	  
	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Isolate the partial path (preceding cursor) within the command
	; line:
	;
	;	.PathPtr/si= address of partial path
	;	.PathLength/cx= length of partial path (0-n)
	;
	; If the preceding path is too big for our find first buffer (less
	; the worst case wildcard amount we may need to append - '\*.*',0),
	; disallow the TAB.

	push	si			;save starting point
	.while	si > offset CmdBuf	;while more chars precede si,
	  mov	al,[si-1]		;al= preceding character
	  .if al == '"' && ([bx].LFN || [bx].SFNQuote)
	    mov byte ptr [si-1],0
	    call CheckQuotes
	    mov [si-1],al
	    .if zero?
	      call CheckPathChar
	      .break .if !zero? && al != '"' || si == offset CmdBuf + 1
	      call IsLFNQuoteChar
	      .break .if !zero?
	    .endif
	  .else
	    .if al == '|'
	      call CheckSBChar
	      .break .if di == -1
	    .else
	      push si
	      dec si
	      call ArePathChars		;is it a file/path character?
	      pop si
	      .break .if !zero?		;break= no, found start of file/path
	    .endif
	  .endif
	  .if [bx].LFN || [bx].SFNQuote
	    call IsLFNQuoteChar
	    .if !zero?
	      mov byte ptr [si-1],0
	      call CheckQuotes
	      mov [si-1],al
	      .break .if zero?
	    .endif
	  .endif
	  dec	si			;back up another character
	.endw
	pop	cx			;cx= count of preceding path chars
	sub	cx,si
	.if	cx > sizeof TABWORK.FindBuf - 5	;if too big to process,
	  jmp	TabCompleteAbort	;jmp= exit w/o additional keystrokes
	.endif
	mov	[bx].PathPtr,si		;save mask start and size
	mov	[bx].PathLength,cx

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Isolate the name portion of the partial path (exclude any prepended
	; specific path - i.e., locate the trailing portion), and store its
	; length and content in .NameLength and .NameStr respectively.  We'll
	; need these info to know how many characters to append when a match
	; is found, and to restore original characters when necessary in both
	; APPEND and CHANGE mode.
	;
	; If no path is prepended, .NameLength == .PathLength.

	mov	di,si			;di= 1 beyond last char in user path
	add	di,cx
	mov	dx,di			;init name length
	jcxz	@F			;jmp= no path specified in prefix

	  ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	  ; Check for and handle special case: if the final character(s) of
	  ; the user entry are a '.' or '..' directory indicator, simply add
	  ; a '\' to the entry and exit.  No searching of any kind is needed.

	  .if ![bx].LFN
	    push di
	    push cx
	    call SkipQuote
	    mov	al,[di]			;fetch last entered char
	    .if	al == '.'		;if may be '.' or '..' directory case,
	      dec	cx		;see if more chars
	      .if	!zero?		;if more chars precede,
	        call SkipQuote
	      .endif
	      .if al != '.' && al != ':' ;set zero flag if definite directory
	        cmp al,'\'
	      .endif
	      .if	zero?		;if user specifying '.' or '..',
	        .if [bx].lmode > 0
	          call EndLastLines
	          mov al,LF
	          call DisplayFormattedAl
	        .endif
	        .if [bx].SFNQuote
	          call CheckQuotesRest
	          .if !zero?
	            mov al,'"'
	            call StoreCharInsertMode
	          .endif
	        .endif
	        mov al,'\'		;always complete by appending '\'
	        call StoreCharInsertMode
	        pop cx
	        pop di
	        .if [bx].lmode > 0
	          call EndBSlash
	        .endif
	        jmp TabCompleteAbort	;jmp= exit w/o additional keystrokes
	      .endif
	    .endif
	    pop cx
	    pop di
	  .endif

	  .repeat			;scan to see if a path is specified,
	    mov	al,[di-1]		;get previous char
	    push di
	    .if al == '\'
	      push si
	      mov si,di
	      call CheckSBChar
	      pop si
	    .endif
	    .if al == ':' || al == '\' && di == -1
	      pop di
	      .break			;break= path indicator found
	    .endif
	    pop di
	    dec	di			;back up
	  .untilcxz			;continue if more partial path remains
	@@:
	sub	dx,di			;save length of final name portion
	mov	[bx].NameLength,dx
	.if dx < sizeof TABWORK.NameStr
		push si
		mov si,di
		lea di,[bx].NameStr
		mov cx,dx
		rep movsb
		pop si
	.endif

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; .Flags init.  If in argument area of command line:
	;
	;	Clear the TW_CMDVERB flag, so we won't restrict the type of
	;	files we'll match.
	;
	;	Clear the TW_PATHSEARCH flag.  This will prevent searching
	;	the system path.
	;
	; Otherwise (in command verb area of command line):
	;
	;	Set the TW_CMDVERB flag, to restrict the type of files we'll
	;	match to .BAT, .EXE and .COM.
	;
	;	If a path is present in the user's entry, clear the
	;	TW_PATHSEARCH flag so we won't search the system path;
	;	otherwise, set TW_PATHSEARCH.

	mov	ah,0			;assume we're in the argument area
	.repeat				;loop to scan in front of prefix,
	  mov	al,CMDSEP		;assume at start of line
	  .break .if si == offset CmdBuf ;break= assumption correct
	  dec	si			;else back up and load prev character
	  mov	al,[si]
	  .if al == '"' && ([bx].LFN || [bx].SFNQuote)	;support quotes in LFN mode or if
	    .if si > offset CmdBuf			;DOS supports it (DOS version 7+)
	      mov al,[si-1]
	      call IsLFNQuoteChar
	      .if !zero?
	        mov al,[si+1]
	        mov byte ptr [si+1],0
	        call CheckQuotes
	        mov [si+1],al
	      .endif
	    .else
	      cmp al,0
	    .endif
	  .else
	    call IsLFNQuoteChar		;char allowed to prefix a command?
	  .endif
	.until zero? && al != TAB	;skip allowable command prefix chars
	.if al == '|'
	  .if [bx].LFN || [bx].SFNQuote
	    mov cl,[si]
	    mov byte ptr [si],0
	    call CheckQuotes
	    mov [si],cl
	  .endif
	 .endif
	.if zero? && al == '|' || al == CMDSEP	;if in command verb area,
	  mov	ah,TW_CMDVERB		;restrict type of file we'll match
	  mov	cx,[bx].NameLength	;if path not present in user entry,
	  .if	cx == [bx].PathLength	;  allow search of system path
	    mov	ah,TW_CMDVERB or TW_PATHSEARCH
	  .endif
	.endif
	mov	[bx].Flags,ah		;store initialized .Flags image

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Main loops.  The outer loop is so we can restart the scan, and
	; skip over entries to a selected point (used to back up via a
	; shift+tab).  The inner loop is for advancing in the list via
	; the tab key.

	xor	cx,cx			;start with skip mode off
	mov	[bx].CharsInserted,cx	;(and no chars inserted)
;030121 .while	1			;loop for backing up,
      .repeat				;loop for backing up,		;030121
	mov	[bx].SkipTo,cx		;install skip count
	and	[bx].TotalDone,0	;initialize count of found names
	or	[bx].Flags,TW_INIT	;cause search initialization to occur
	.repeat				;loop to fetch next name
	@@:
	  call	TabNextName		;attempt to get the next name
	  mov	cx,[bx].TotalDone	;total names loaded so far
	  jcxz	TabNoMatch		;jmp= no names match, exit tab mode
	  .if	!zero?			;if a name was acquired,
	    cmp	cx,[bx].SkipTo		;should this entry be skipped?
	    jb	@B			;jmp= yes, skip it

	    ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	    ; Insert completion string into CmdBuf.  We only insert that
	    ; portion of the name beyond what the user has already typed; and
	    ; then we add a '\' or ' ' to the end.  Note we must be careful:
	    ; the found name may actually be shorter than the prefix string
	    ; entered (e.g., prefix "foo." will match "foo"); so we only limit
	    ; our skipping in the found name to what's really there.

	    call GetFiFileName
	  .elseif [bx].lmode > 0
	  	call EndBSlash
		call SetRow
		mov [bx].lmode,-1
	  .endif
	  .if [bx].lmode > 0
	  	call	CheckMore
	  	.break .if ax == ESCAPE
	  .elseif [bx].lmode == -1
	  	inc [bx].lmode
	  .else
	  	call	GetKeybCharNoEcho	;get next user keystroke
	  	.break .if ax == 100h + CTRLTAB && dl
	  .endif
	.until	ax != TAB && ax != 100h + CTRLTAB && [bx].lmode == 0		;loop if tabbing to next match

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; If not shift+tab, exit tab mode.

	call	CloseHandle
	cmp	ax,100h + SHFTAB	;shift+tab?
	jnz	TabCompleteExit		;jmp= no, exit (process externally)

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Shift+tab - back up to the previously inserted name.  If we're
	; at the start of the list, "back up" to an empty entry (done by
	; simply exiting, after removing the previous insertion).
	; Note we don't keep a list of the completions, so the only way to
	; back up is to restart the scan and skip to where we want to be.

        call	ResChars

;030121	jz	TabCompleteAbort	;jmp= backing out of list altogether
;030121 .endw				;loop to restart scan to back up
      .until	zero?			;loop if another exists in list	;030121
      call	ResQuote
      skip
TabNoMatch:
      mov ah,-1
      endskip
      skip
TabCompleteAbort:
	xor ah,ah
	endskip
	.if [bx].lmode > 0
	  .if ah != -1
	    call DisplayCRLF
	  .elseif [bx].CharsInserted != -1
	    call EndBSlash
	  .endif
	  call SetRow
	  mov [bx].lmode,0
	.endif
	mov	ax,LF			;note: linefeed is defined to be NOP

TabCompleteExit:

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; 030121 Start of fix: If the completion session ended with a CR,
	;	remove a trailing backslash, if one is present at the end of
	;	what was added.  This makes the 16-bit CD, RD & COPY commands
	;	happy -- they disallow a trailing backslash on a dir name.
	; 030926 Extended above to include a space, so commands like
	;	REN dir newdir or COPY dir otherdir work better when source
	;	is a directory name (they disallow a trailing '\').

;030926	.if	ax == CR		;if tab session was ended w/a CR, space, or other editing keys 201408
	.if	ax == CR || ax == ' ' || ah == 1 && (al == LEFT || al == RIGHT || al == HOME || al == ENDKEY || al == ALTF6)
	  mov	cx,[bx].CharsInserted	;chars we inserted above (if any)
	  jcxz	@F			;if we inserted something,
	    call Get_cbCurrent_cbLast	;si= 1 beyond last inserted char
	    .if	byte ptr [si-1] == '\'	;if final char was a backslash,
	      .if !([bx].Flags & TW_CMDVERB) ;and not in verb portion of line,
		.if al == LEFT
		  mov al,LF
		.elseif (al == RIGHT || al == ENDKEY) && !byte ptr [si]
		  mov ax,' '
		.endif
		push ax
		push bx
		call BackSpace		;remove it
		pop bx
		pop ax
	      .endif
	    .endif
	    .if [bx].LFN || [bx].SFNQuote
	      call CheckQuotesRest
	      .if !zero?
	        push ax
	        mov al,'"'
	        call StoreCharInsertMode
	        pop ax
	      .endif
	    .endif
	  @@:
	.elseif ax == 24
	  mov ax,LF
	.endif

	jmp TabEnd

EndBSlash label near
	push ax
	mov al,scInfo.CurrentRow
	dec al
	mov ah,scInfo.TotalRows
	sub ah,4
	.if al > scInfo.EntryRow && al > ah
	  call ShowLFs
	.endif
	pop ax
	ret

EndLastLines label near
	mov ah,scInfo.CurrentRow
	mov al,scInfo.TotalRows
	dec al
	.if ah <= scInfo.EntryRow || ah < al
	  ret
	.endif

ShowLFs:				;change to new lines in F11 mode etc
	sub al,scInfo.EntryRow
	.while al > 0
	  push ax
	  mov al,LF
	  call OutputAl
	  pop ax
	  dec al
	.endw
	ret

SetRow label near			;refresh the display in F11 mode
	push ax
	xor cx,cx
	mov dx,-1
	call BackupCxChars
	pop ax
	ret

SkipQuote:				;skip quotes when processing dots in SFN mode
	dec di
	mov al,[di]			;get char in front of the '.'
	.while [bx].SFNQuote && al == '"'
		dec di
		dec cx
		.break .if zero?
		mov al,[di]
	.endw
	ret

ChangeQuotes:				;change/remove/reformat unnecessary quotes in CHANGE mode
	lea di,[bx].FindBuf
	push di
	xor cx,cx
	.repeat
	  mov al,[si-1]
	  .if al == '"'
	    inc cx
	  .else
	    push di
	    .if al == '|'
	      call CheckSBChar
	    .endif
	    .if al != '|' || di == -1
	      call IsLFNQuoteChar
	      .if !zero? || al == '|' || al == '<' || al == '>' || al == TAB
	        call CheckQuotes
	        .if zero?
	          pop di
	          .break
	        .endif
	      .elseif ![bx].LFN
	        push si
	        dec si
	        call IsLFNPathChar
	        pop si
	        .if !zero?
	          call CheckQuotes
	          .if zero?
	            pop di
	            .break
	          .endif
	        .endif
	      .endif
	    .endif
	    pop di
	    stosb
	  .endif
	  dec si
	  push bx
	  push cx
	  push si
	  push di
	  call BackSpace
	  pop di
	  pop si
	  pop cx
	  pop bx
	.until si == offset CmdBuf
	.if cx
	  mov al,'"'
	  push cx
	  push di
	  call StoreCharInsertMode
	  pop di
	  pop cx
	.endif
	pop si
	.while di > si
	  dec di
	  mov al,[di]
	  push cx
	  push si
	  push di
	  call StoreCharInsertMode
	  pop di
	  pop si
	  pop cx
	.endw
	call	Get_cbCurrent_cbLast
	mov al,'"'
	mov ch,cl
	and cl,1
	.if zero? && ch && byte ptr [si] && [si] != al
	  call StoreCharInsertMode
	.endif
	call	Get_cbCurrent_cbLast
	ret

CheckPathChar:				;check for path chars
	push si
	dec si
	dec si
	mov al,[si]
	call IsPathChar
	pushf
	.if zero? && ![bx].LFN
	  popf
	  call IsLFNPathChar
	.else
	  popf
	.endif
	pop si
	ret

ArePathChars:				;check if they are valid path chars in SFN and LFN mode respectively
	push ax
	call IsPathChar
	pop ax
	pushf
	.if zero? && al == ' ' && [bx].SFNQuote
	  popf
	  ret
	.endif
	popf
	pushf
	.if zero? && ![bx].LFN
	  popf
	  call IsLFNPathChar
	  pushf
	  .if zero?
	    popf
	    call IsLFNQuoteChar
	  .else
	    popf
	  .endif
	.else
	  popf
	.endif
	ret

ResChars:				;restore the original chars; there are more work if in CHANGE mode
	call	TabRemove		;remove previous completion
	.if cmode & CM_CHANGE
	  mov bp,[bx].NameLength
	  .if bp > 0 && bp < sizeof TABWORK.NameStr
	    lea di,[bx].NameStr
	    push bp
	    push di
	    push bx
	    .repeat
		call BackSpace
		dec bp
	    .until bp == 0
	    pop bx
	    pop di
	    pop bp
	    .repeat
		mov al,[di]
		push di
		call StoreCharInsertMode
		pop di
		inc di
		dec bp
	    .until bp == 0
	  .endif
	.endif
	mov	cx,[bx].TotalDone	;count of name(s) acquired
	.if	cx != -1
	  dec	cx			;count needed if we back up one
	.endif
	ret

GetFiFileName:				;get the SFN or LFN FindFirst name
	.if [bx].TotalDone == -1
	  ret
	.endif
	call TabRemove			;first remove any previous completion
	call Get_cbCurrent_cbLast	;save cursor startpoint
	push si
	mov cx,[bx].NameLength		;cx= user-entered chars to skip over
	push cx
	xor dh,dh
	call ReDisplay
	.if [bx].LFN
	  call CheckLFNMatch
	.else
	  lea si,Find1st.fiFileName	;si= start of matched name
	.endif
	.if [bx].LFN || [bx].SFNQuote
	  call CheckSpChar
	.endif
	pop	bp
	mov 	[bx].NameLength,bp
	.if cmode & CM_CHANGE || !bp
	  dec	si			;compensate for 1st loop
	  inc	cx
	.endif
	lea	di,[bx].NameStr
	.repeat				;limit skip to what exists in match
	  mov al,[di]
	  xor ah,ah
	  .if !bp || al != '"' || bp == 1 && cmode & CM_CHANGE || ![bx].LFN && ![bx].SFNQuote
	    call CheckDBCSChar
	  .endif
	  inc di
	.untilcxz byte ptr [si] == 0
	xor bp,bp
	mov al,scInfo.EntryRow
	.if [bx].lmode > 0 && al == scInfo.CurrentRow
	  inc bp
	.endif
	push dx
	call StoreStringInsertMode	;insert string into CmdBuf
	pop dx
	.if [bx].LFN || [bx].SFNQuote
		call CheckQuotesRest
		.if !zero? || dh
		  mov al,'"'
		  call StoreCharInsertMode
		.endif
	.endif
	xor dl,dl
	.if [bx].LFN && Find1stL.fiAttribute & ATTR_DIRECTORY || ![bx].LFN && Find1st.fiAttribute & ATTR_DIRECTORY ;if dir name,
	  mov al,'\'			;insert a final '\' if it is a directory
	  inc dl
	.else
	   mov al,' '			;add a trailing blank if it is a file
	   call Get_cbCurrent_cbLast
	   .if [bx].lmode > 0 && !byte ptr [si]
	     xor al,al
	   .endif
	.endif
	push dx
	call StoreCharInsertMode
	call Get_cbCurrent_cbLast	;get cursor endpoint
	pop dx
	pop di				;si= count of inserted chars	;030121
	.if (si == di && dl) && cmode & CM_CHANGE
	  mov si,-1
	.elseif si < di && cmode & CM_CHANGE
	  sub si,di
	  dec si
	.else
	  push di
	  mov al,[si-1]
	  .if al && al != ' ' && (!dl || al != '\')
	    push [si-1]
	    mov byte ptr [si],7fh
	    inc si
	    call CheckSBChar
	    dec si
	    pop [si-1]
	    .if di != -1
	      push bx
	      push si
	      call BackSpace		;if the second byte of a DBCS character
	      pop si			;failed to be inserted (no space left),
	      pop bx			;remove the DBCS leading byte as well
	      dec si
	    .endif
	  .endif
	  pop di
	  sub si,di							;030121
	.endif
	mov [bx].CharsInserted,si	;save count of inserted chars	;030121
	.if [bx].lmode > 0
	  .if !bp
	    call EndLastLines
	  .endif
	  call DisplayCRLF
	.endif
	ret

ReDisplay label near			;display/change the part that the user has already typed when necessary
	.if (cmode & CM_CHANGE || [bx].lmode > 0) && cx > 0
	    push bx
	    .repeat
	      .if cmode & CM_CHANGE
	        lea si,[bx].NameStr
	        add si,cx
	        .if byte ptr [si-1] == '"'
	          inc dh
	        .endif
	        push cx
	        push dx
	        call BackSpace
	        pop dx
	        pop cx
	      .else
	        mov al,BS
	        call OutputAl
	      .endif
	      dec cx
	    .until cx == 0
	    pop bx
	.endif
	.if [bx].lmode > 0
	  call Get_cbCurrent_cbLast	;get cursor endpoint
	  .if !(cmode & CM_CHANGE)
	    sub si,[bx].NameLength
	  .endif
	  .if ([bx].LFN || [bx].SFNQuote) && si > offset CmdBuf && byte ptr [si-1] == '"'
	      mov al,BS
	      call OutputAl
	      mov al,'"'
	      call OutputAl
	  .endif
	  .if !(cmode & CM_CHANGE)
	    lea di,[bx].NameStr
	    .while cx < [bx].NameLength
	      mov al,[di]
	      call OutputAl
	      inc cx
	      inc di
	    .endw
	  .endif
	.endif
	ret

CheckLFNMatch:				;check for case where user input only matches SFN and not LFN in LFN + APPEND
	lea si,Find1stL.fiFileName	;mode, e.g. WINDOW~1 instead of WINDOWSSETUP even if LFN is available.
	push cx
	lea di,[bx].NameStr
	mov bp,cx
	push bp
	.while bp > 0
	  mov al,[di]
	  .if al == '"'
	    dec cx
	  .endif
	  dec bp
	  inc di
	.endw
	pop bp
	.if cx > 0 && cx < 15
	  lea di,[bx].NameStr
	  push si
	  push di
	  push bp
	  .repeat
	    dec bp
	    mov al,[si]
	    call ToLower
	    mov ah,al
	    mov al,[di]
	    call ToLower
	    .if al != '"'
	      .if ah != al && al != '?'
	        mov [bx].NameLength,-1
	       .break
	      .endif
	      xor ah,ah
	      call CheckDBCSChar
	    .endif
	    inc di
	  .until bp == 0
	  pop bp
	  pop di
	  pop si
	  push di
	  .if [bx].NameLength == -1
	    lea si,Find1stL.fiSFileName
	    push si
	    .repeat
	      dec bp
	      mov al,[si]
	      call ToLower
	      mov ah,al
	      mov al,[di]
	      call ToLower
	      .if al != '"'
	        .if ah != al && al != '?'
	          dec [bx].NameLength
	         .break
	        .endif
	        xor ah,ah
	        call CheckDBCSChar
	      .endif
	      inc di
	    .until bp == 0
	    pop si
	    .if [bx].NameLength != -1
	      lea si,Find1stL.fiFileName
	    .endif
	  .endif
	  pop di
	.endif
	pop cx
	ret

CheckSpChar:				;check if there are special characters like spaces or "," in filename and add
	push si				;quotes accordingly if quotes are supported by the DOS version that is used
	push cx
	lea di,[bx].NameStr
	xor ah,ah
	.while cx > 0
	  mov al,[di]
	  .if al != '"'
	    call CheckDBCSChar
	  .endif
	  dec cx
	  inc di
	  .break .if byte ptr [si] == 0
	.endw
	.repeat
	  mov al,[si]
	  call IsLFNQuoteChar
	  .if !zero?
	    mov byte ptr [si],0
	    call CheckQuotes
	    mov [si],al
	    .if zero?
	      mov bp,-1
	      push si
	      call Get_cbCurrent_cbLast
	      .if si > offset CmdBuf && byte ptr [si-1] == '\' && cmode & CM_CHANGE
	        lea di,[bx].FindBuf
	        push di
	        .repeat
	          dec si
	          mov al,[si]
	          call ArePathChars
	          .break .if !zero?
	          call IsLFNQuoteChar
	          .break .if !zero? || si < offset CmdBuf
	          stosb
	          push bx
	          push si
	          push di
	          call BackSpace
	          pop di
	          pop si
	          pop bx
	        .until 0
	        pop bp
	      .endif
	      mov al,'"'
	      push di
	      call StoreCharInsertMode
	      pop di
	      inc dh
	      .if bp >=0
	        dec di
	        .while di >= bp
	          mov al,[di]
	          push di
	          call StoreCharInsertMode
	          pop di
	          dec di
	        .endw
	      .endif
	      pop si
	    .endif
	    .break
	  .endif
	  inc si
	.until al == 0
	pop cx
	pop si
	ret

CheckDBCSChar label near		;check if DBCS is supported by DOS and handle double-byte characters accordingly;
	inc si				;for example, it will skip double bytes instead of single one when necessary if it
	.if al == '?' && [bx].LFN && !(cmode & CM_CHANGE) || ah == -1	;is in LFN + APPEND mode and the "?" wildcard is
	  push cx							;used; it is also useful for checking some special
	  push dx							;characters such as the pipe char ("|") and the
	  push ds							;backslash ("\") as the second byte of a DBCS
	  push si							;character even in SFN or CHANGE mode; last but not
	  push ax							;the least, editing keys such as BackSpace & DELETE
	  mov ax,6300h							;will actually remove a DBCS character consisting of
	  int 21h							;two bytes instead of one on a DBCS-enabled system;
	  pop ax							;similar for overwriting a DBCS character with a
	  mov dx,[si]							;regular single-byte character etc on such systems
	  mov cx,[si+2]
	  pop si
	  pop ds
	  .if dl >= 80h && dh >= dl && ([si-1] >= dl && [si-1] <= dh || cl >= 80h && [si-1] >= cl && [si-1] <= ch) && byte ptr [si] >= 40h
	    inc si
	  .endif
	  pop dx
	  pop cx
	.endif
	ret

TabEnd:
	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; 030121 End of fix

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Restore entry DTA.

	pop	dx			;bx:dx= DTA saved on entry
	pop	bx

	push	ax
	push	ds
	mov	ds,bx			;restore entry DTA
	mov	ah,1ah
	int	21h
	pop	ds
	pop	ax
	
	.if ax == 100h + CTRLTAB
	  jmp TabComplete
	.endif

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Exit - ax will hold keystroke that caused us to exit TAB mode (or
	; a zero, which is ignored by the keystroke dispatcher).

	jmp	DispatchKeystroke	;dispatch char that ended completion

TabComplete	endp

CheckMore:				;check if time for -- More -- prompt
	mov ah,[bx].lmode
	mov al,scInfo.CurrentRow
	sub al,scInfo.EntryRow
	.if al > 0
	  add ah,al
	.else
	  inc ah
	.endif
	.if ah >= scInfo.TotalRows
	  lea di,MoreMsg		;display -- More --
	  .repeat
	    mov al,[di]
	    push ax
	    call OutputAl
	    pop ax
	    inc di
	  .until al == 0
	  mov al,CR
	  call OutputAl
	  lea si,CmdBuf
	  mov cl,[si]
	  mov byte ptr [si],0
	  call GetKeybCharNoEcho	;wait for keystroke
	  mov [si],cl
	  push ax
	  call DisplayCRLF
	  mov [bx].lmode,1
	  mov al,scInfo.CurrentRow
	  .if al > scInfo.EntryRow
	    inc scInfo.EntryRow
	  .endif
	  pop ax
	  .if ax == ESCAPE
	    call EndBSlash
	    call SetRow
	  .endif
	.else
	  inc [bx].lmode
	.endif
	ret

CheckSBChar:				;check for case that a DBCS character contains
	push si				;chars such as a pipe char ("|") or a backslash
	mov di,si			;("\") as the second byte, since these chars
	dec di				;are usually used as separators etc
	lea si,CmdBuf
	mov ah,-1
	.while byte ptr [si] && (si < CmdLineLimit || si <= CmdLineLimit && byte ptr [si] == 7fh)
	  .if si == di
	    mov di,-1
	    .break
	  .endif
	  call CheckDBCSChar
	.endw
	inc ah
	pop si
	ret

CheckQuotes:				;check if there are unmatched quotes up to the cursor position
	push ax
	push si
	push di
	xor ax,ax
	call Get_cbCurrent_cbLast
	mov di,offset CmdBuf
	.while byte ptr [di] && di < si
	  .if byte ptr [di] == '"'
	    inc ax
	  .endif
	  inc di
	.endw
	and ax,1
	pop di
	pop si
	pop ax
	ret

CheckQuotesRest:			;if there are unmatched quotes up to the cursor position, check
	call CheckQuotes		;the rest command line for the existence of other quotes
	.if !zero?
	  push ax
	  push si
	  push di
	  call Get_cbCurrent_cbLast
	  mov al,[si]
	  xor ah,ah
	  .while al && si < di && si < CmdLineLimit
	    .if al == '"'
	      inc ah
	      .break
	    .endif
	    inc si
	    mov al,[si]
	  .endw
	  cmp ah,1
	  pop di
	  pop si
	  pop ax
	.endif
	ret

ResQuote:				;restore the transferred quote in CHANGE mode if quotes are supported
	call Get_cbCurrent_cbLast	;get cursor endpoint
	mov cx,[bx].NameLength
	sub si,cx
	mov al,[si-1]
	.if ([bx].LFN || [bx].SFNQuote) && cmode & CM_CHANGE && si > offset CmdBuf && al == '\' && !(si > offset CmdBuf + 1 && byte ptr [si-2] == '"')
	  mov byte ptr [si-1],0
	  call CheckQuotes
	  mov [si-1],al
	  .if !zero?
	    push bx
	    .if [bx].lmode > 0
	      call SetRow
	    .endif
	    .repeat
	      push cx
	      call BackSpace
	      pop cx
	      .break .if cx == 0
	      dec cx
	    .until 0
	    pop bx
	    lea si,[bx].NameStr
	    push si
	    xor dl,dl
	    .while cx < [bx].NameLength
	      lodsb
	      .if al == '"'
	        dec [bx].NameLength
	      .endif
	      call IsLFNQuoteChar
	      .if !zero?
	        inc dl
	        .break
	      .endif
	      inc cx
	    .endw
	    call CheckQuotesRest
	    .if !zero? && !dl
	      mov al,'"'
	      call StoreCharInsertMode
	    .endif
	    mov al,'\'
	    call StoreCharInsertMode
	    pop si
	    push si
	    add si,[bx].NameLength
	    mov byte ptr [si],0
	    pop si
	    call StoreStringInsertMode
	  .endif
	.endif
	ret

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Removes a previous completion (if any) from the command line buffer.

TabRemove proc near
	xor dh,dh
	.if ([bx].LFN || [bx].SFNQuote) && cmode & CM_CHANGE
	  call Get_cbCurrent_cbLast
	  sub si,[bx].CharsInserted
	  sub si,[bx].NameLength
	  .if byte ptr [si] == '\' && [bx].CharsInserted > 0
	    mov byte ptr [si],0
	    call CheckQuotes
	    .if !zero?
	      inc dh
	    .endif
	    mov byte ptr [si],'\'
	  .endif
	.endif
	xor	cx,cx			;fetch/clear count of inserted chars
	xchg	cx,[bx].CharsInserted
	push	bx			;remove char(s) from CmdBuf
	push	cx
	xor	bp,bp
	sub	bp,cx
	xor	dl,dl
	.if [bx].lmode > 0
	  dec	dl
	.endif
	.if !(bp > 0 && bp < 0ffh)
	  call	BackupCxChars
	.endif
	pop	cx
	.if [bx].lmode > 0 && dl >= 0
	  .if [bx].lmode == 1 && dl > 0
	    dec [bx].lmode
	  .endif
	  add [bx].lmode,dl
	  mov dl,-1
	.endif
	.if bp > 1 && bp < 0ffh
	  .while bp > 1
	    call Get_cbCurrent_cbLast
	    push dx
	    .if !byte ptr [si]
	      mov al,' '
	      call StoreCharInsertMode
	    .endif
	    call ForwardChar
	    pop dx
	    dec bp
	  .endw
	.elseif bp != 1
	  call	DeleteCxChars
	.endif
	pop	bx
	.if dh
	  xor cx,cx
	  call Get_cbCurrent_cbLast
	  lea di,[bx].FindBuf
	  .repeat
		dec si
		mov al,[si]
		stosb
		inc cx
		push ax
		push bx
		push cx
		push si
		push di
		call BackSpace
		pop di
		pop si
		pop cx
		pop bx
		pop ax
	  .until al == '"' || si <= offset CmdBuf
	  dec di
	  .while cx > 0
		dec di
		mov al,[di]
		push di
		push cx
		call StoreCharInsertMode
		pop cx
		pop di
		dec cx
	  .endw
	  mov al,'\'
	  call StoreCharInsertMode
	.endif
	ret
TabRemove endp

CloseHandle:				;close the file handle if in LFN mode
	.if [bx].LFN
	  push ax
	  push bx
	  mov bx,[bx].FHandle
	  mov ax,71a1h
	  int 21h
	  pop bx
	  pop ax
	.endif
	ret

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Acquires next matching file/directory entry for completion.  If successful,
; the acquired name is left in the TABWORK.Find1st work area.
;
; IN:
;   bx= TABWORK area base address
;
; OUT:
;   [bx].Find1st= holds find first/find next result, if new name acquired
;   [bx].TotalDone= incremented, if a new name is acquired
;   zero status if another name could not be acquired (i.e., end of list)

TabNextName proc near

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; If first search:
	;
	; If the user has not entered a specific path, we'll need the
	; .NextPathPtr to point to potential directories to search.  If we're
	; in the command verb area, point it to the system path; otherwise,
	; point it to an empty list, to include only the current directory.
	;
	; Also set the carry if this is the first search, to cause the find
	; performed below to be a find first instead of a find next.

	.if [bx].TotalDone == -1
	  ret
	.endif
	mov	al,[bx].Flags		;load flags image
	test	al,TW_INIT		;clear carry, nz if need to init
	.if	!zero?			;if need to init,
	  .if [bx].lmode == 1
	    push ax
	    call EndLastLines
	    mov al,LF
	    call DisplayFormattedAl
	    pop ax
	    inc [bx].lmode
          .endif
	  push	es
;030121	  push	di
	  mov	di,offset SingleZero	;assume current dir search only
	  and	al,TW_CMDVERB or TW_PATHSEARCH	;isolate path search flags
	  .if	al == TW_CMDVERB or TW_PATHSEARCH ;if path search required,
	    push bx
	    mov  ah,51h			;bx= current PSP segment
	    int  21h
	    mov  es,bx			;es:di= environment block
	    mov  es,es:[ENV_OFFSET]
	    xor  di,di
	    mov  si,offset PathEquals	;search environment for path=
	    call StringListPoolSearch
	    pop  bx
	  .endif
	  mov	word ptr [bx].NextPathPtr,di ;set potential path search list
	  mov	word ptr [bx].NextPathPtr+2,es
;030121	  pop  di
	  pop  es
	  stc				;insure carry is set for below
	.endif

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Execute find first/find next (if carry is set entering here, we do
	; a find first; otherwise, we do a find next.
	;
	; Note: normally we search for all matching files and directories;
	; however, we exclude directories if we're searching a directory
	; from the path (which means the current directory has already been
	; searched).

FindFirstNext:
	.repeat				;loop to scan directory(ies),
	  mov	cx,ATTR_DIRECTORY	;default to find files and directories
	  .if	carry?
	    call TabBuildFullPath	;build find first mask
	    .if zero?
	      ret			;return= no more - exit w/zero status
	    .endif
	    call AddSysHidden
	    .if [bx].LFN		;if LFN API is available
	      lea di,Find1stL
	      mov ax,714eh		;find first
	      push cx
	      mov si,1
	      int 21h			;perform find first/next
	      pop cx
	    .else
	      lea di,Find1st
	      mov ax,7100h
	    .endif
	    pushf
	    .if ax == 7100h
	    	popf
	    	mov [bx].LFN,0		;try SFN counterpart
	    	mov ax,4e00h
	    	int 21h
	    .else
	    	popf
	    	pushf
	    	call CheckDots
	    	popf
	    .endif
	  .else
	    lea	dx,[bx].FindBuf
	    push bx
	    .if [bx].LFN		;if LFN API is available
	   	mov ax,714fh		;find next
	   	lea di,Find1stL
	   	mov bx,[bx].FHandle
	   	mov si,1
	    .else
	   	mov ax,4f00h
	   	lea di,Find1st
	    .endif
	    int	21h			;perform find first/next
	    pop bx
	    .if carry?
	       .if ![bx].CharsInserted
	         call ResQuote
	       .endif
	   	call CloseHandle
	    stc
	    .endif
	  .endif
	.until	!carry?			;loop if time to try next directory
	jmp FiltrateEntries

AddSysHidden:				;include system and hidden files/directories
	lea dx,[bx].FindBuf		;if /S option is turned on
	.if cmode & CM_SYSHIDDEN
	  add cx,ATTR_SYSHIDDEN
	.endif
	ret

CheckDots:				;check for consecutive dots in LFN mode
	mov [bx].FHandle,ax		;skip and/or add quotes when necessary
	mov ax,[bx].NameLength
	.if carry? && ![bx].CharsInserted
	  .if ax > 0
		lea di,[bx].NameStr
		xor bp,bp
		.repeat
		  .break .if byte ptr [di] != '.' && byte ptr [di] != '"'
		  .if byte ptr [di] == '.'
		    inc bp
		  .endif
		  inc di
		  dec ax
		.until ax == 0
		.if !ax && bp
		  call CheckQuotesRest
		  .if !zero?
		    mov al,'"'
		    call StoreCharInsertMode
		  .endif
		  mov al,'\'
		  call StoreCharInsertMode
		  dec [bx].CharsInserted
		  .if [bx].lmode > 0
		    call EndBSlash
		    call DisplayCRLF
		  .endif
		  ret
		.endif
	  .endif
	  call ResQuote
	.endif
	ret

SearchExt:				;search SFN and LFN for executable extensions
	lea	si,[di-5]		;si= start of suspected .com/.bat/.exe
	sub	dx,si			;carry clear= backed up too far
	.if carry? && byte ptr [si] == '.'
	    mov	di,offset CommandExts	;search for valid command .ext
	    call StringListPoolSearch
	.endif
	clc				;assume extension not found
	ret

FiltrateEntries:
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Ignore the '.' and '..' entries.  These names are completed with
	; special logic (they are never searched for).
	; Exception: User entered '.' as the first character in LFN mode.
	; This is useful for long file/dir names starting with dots.

	lea	di,Find1st.fiFileName ;di= ptr to start of found name
	.if [bx].LFN
	  lea	di,Find1stL.fiFileName ; LFN version
	.endif
	lea	si,[bx].NameStr
	xor	cx,cx
	.if [bx].LFN || [bx].SFNQuote
	  .repeat
	    .break .if cx >= [bx].NameLength || byte ptr [si] != '"'
	    inc si
	    inc cx
	  .until 0
	.endif
	.if ![bx].LFN || [bx].NameLength == 0 || byte ptr [si] != '.'
	  mov	si,di			;ignore '.' and '..'
	  .repeat				;dummy block (to support breaks)
	    lodsb				;set zero status if '.' or '..' entry
	    .break .if al != '.'
	    lodsw
	    .break .if al == 0
	    cmp ax,'.'
	  .until 1			;end dummy block (to support breaks)
	  .if zero?
	    jmp FindFirstNext		;jmp= '.' or '..' entry, ignore
	  .endif
	  .if ![bx].LFN
	    push si
	    push di
	    xor cx,cx
	    lea si,Find1st.fiFileName
	    lea di,[bx].NameStr
	    .while cx < [bx].NameLength
	      mov al,[di]
	      .if al != '"'
	        .if al == '?' && byte ptr [si] == '.'
	          pop di
	          pop si
	          jmp FindFirstNext
	        .endif
	        inc si
	      .endif
	      inc di
	      inc cx
	    .endw
	    pop di
	    pop si
	  .endif
	.endif

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; 011212: (got tired of uppercase).  Converted find buffer chars to
	; lowercase, in-place.

	mov	dx,di			;save for extension check (to follow)
	.repeat				;convert result to lowercase, in-place
	  mov	al,[di]
	  ;call	ToLower			;disabled for LFN support
	  ;stosb
	  inc	di
        .until  al == 0

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; If performing a command completion, only allow files with
	; appropriate extensions (but allow directories of any name).

	.if	[bx].Flags & TW_CMDVERB	;if command completion,
	  .if	!([bx].LFN && Find1stL.fiAttribute & ATTR_DIRECTORY || ![bx].LFN && Find1st.fiAttribute & ATTR_DIRECTORY) ;if not a dir,
;011212	    mov	ch,255			;scan to end of file/dir name
;011212	    mov	al,0
;011212	    mov	dx,di			;(save start of asciiz name)
;011212	    repne scasb
	    call SearchExt
	    .if !zero?
	      .if ![bx].LFN
	        jmp FindFirstNext
	      .endif
	      lea di,Find1stL.fiSFileName	;try search associated SFN instead
	      mov	dx,di
	      .repeat
	        mov	al,[di]
	        inc	di
              .until  al == 0
              call SearchExt
	      .if !zero?
	        jmp FindFirstNext
	      .endif
	    .endif
	  .endif
	  jmp SuccMatch
	.endif
	call	Get_cbCurrent_cbLast	;get cb pointers
	.repeat				;if commands are CD/CHDIR/MD/MKDIR/RD/RMDIR, only allow directories
	  mov al,[si-1]
	  .if al == '|'
	    call CheckSBChar
	  .endif
	  dec si
	  .if al == '|' && di == -1 || al == '<' || al == '>'
	    .if [bx].LFN || [bx].SFNQuote
	      mov byte ptr [si],0
	      call CheckQuotes
	      mov [si],al
	    .endif
	  .endif
	.until zero? && (al == '|' || al == '<' || al == '>') || al == CMDSEP || si < offset CmdBuf
	.if si >= offset CmdBuf && (al == '<' || al =='>')
	  jmp SuccMatch
	.endif
	mov bp,CmdLineLimit
	.repeat
	  inc si
	  mov al,[si]
	  .break .if al == 0 || si == bp
	  call IsWhitespace
	.until !zero?
	mov di,si
	lea si,[bx].FindBuf
	sub bp,3
	.if di < bp
	  mov al,[di+2]
	  mov ah,5
	  dec bp
	  dec bp
	  call IsWhitespace
	  .if zero? || !al || di >= bp
	    mov ah,2
	  .else
	    mov al,[di+5]
	    call IsWhitespace
	    jnz SuccMatch
	  .endif
	  push si
	  .while ah > 0
	    mov al,[di]
	    mov [si],al
	    inc si
	    inc di
	    dec ah
	  .endw
	  mov byte ptr [si],0
	  pop si
	  push si
	  call CheckMacro
	  pop si
	  jz SuccMatch
	  mov di,offset DirCmds
	  call StringListPoolSearch
	  .if zero? && !([bx].LFN && Find1stL.fiAttribute & ATTR_DIRECTORY || ![bx].LFN && Find1st.fiAttribute & ATTR_DIRECTORY)
	    jmp FindFirstNext
	  .endif
	.endif

SuccMatch:				;a match is successful, but for APPEND mode and with * wildcard
	xor ax,ax			;present, append '*.*', '.*' or '*' when necessary instead
	mov cx,[bx].NameLength
	lea di,[bx].NameStr
	push cx
	.while cx > 0
	  .if byte ptr [di] == '*'
	    inc ah
	  .elseif byte ptr [di] == '.'
	    inc al
	  .endif
	  dec cx
	  inc di
	.endw
	pop cx
	.if !ah || cmode & CM_CHANGE
	  ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	  ; Increment count of successfully found names.  Note this also sets
	  ; a non-zero return status, which indicates a new name was found.
	  inc [bx].TotalDone		;bump count of returned names
	  ret
	.endif
	push di
	push ax
	call ReDisplay
	pop ax
	call Get_cbCurrent_cbLast
	pop di
	dec di
	push si
	lea si,[bx].NameStr
	.while di > si && byte ptr [di] == '"'
	  dec di
	.endw
	mov si,offset StarDotStar
	.if !al && byte ptr [di] == '*' && ![bx].LFN
	  inc si
	.elseif al || [bx].LFN
	  inc si
	  inc si
	  .if byte ptr [di] == '*'
	    inc si
	    xor ah,ah
	  .endif
	.endif
	call StoreStringInsertMode
	.if [bx].LFN || [bx].SFNQuote
	  call CheckQuotesRest
	  .if !zero?
	    mov al,'"'
	    call StoreCharInsertMode
	  .endif
	.endif
	call Get_cbCurrent_cbLast
	pop di
	sub si,di
	mov [bx].CharsInserted,si
	.if [bx].lmode > 0 && (si || !ah)
	  mov al,scInfo.CurrentRow
	  inc al
	  .if al == scInfo.TotalRows
	    call OutputCRLF
	  .else
	    call DisplayCRLF
	  .endif
	.endif
	dec [bx].TotalDone
	ret

TabNextName endp

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Builds the next full path mask in [bx].FindBuf.
;
; The full path mask is built from the next path entry (if searching the
; path) and the user command-line filespec (appropriately extended with
; wildcards, if necessary).
;
; IN:
;   bx= TABWORK area base address
;
; OUT:
;   [bx].FindBuf= holds ASCIIZ path math
;   zero status if another path could not be built

STOSB_IF_CX macro		;executes <stosb, dec cx> if cx is non-zero
	local	cxzero
	jcxz	cxzero
	  stosb
	  dec	cx
	cxzero:
	endm

TabBuildFullPath proc near
      .if	!([bx].Flags & TW_INIT)	;if current dir already searched,
        xor cx,cx			;exclude directories from search
      .endif
      push cx			;save find attribute mask
      .repeat				;loop in case we overflow our buffer

	lea	di,[bx].FindBuf		;build path here
	mov	cx,sizeof TABWORK.FindBuf ;max path length
	.if	!([bx].Flags & TW_INIT)	;if this is not the first path,

	  ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	  ; Move the .NextPathPtr entry to the start of the mask buffer.

	  push	ds
	  lds	si,[bx].NextPathPtr	;ds:si= pointer to next path to use
	  .repeat			;skip leading whitespace or ';' chars
	    call SkipWhitespace
	    inc  si			;assume we've hit a ';'
	  .until al != ';'		;loop if assumption correct
	  dec	si			;undo 1 too many advances
	  .while al != 0 && al != ';'	;while haven't hit entry terminator,
	    inc	si			;consume the character
	    STOSB_IF_CX			;stosb and dec cx, if cx is non-zero
	    call SkipWhitespace		;ignore any whitespace
	  .endw
	  pop	ds			;update next path ptr
	  mov	word ptr [bx].NextPathPtr,si

	  cmp	cx,sizeof TABWORK.FindBuf ;was a path available to move in?
	  .break .if zero?		;break= no, exit w/zero status

	  ;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	  ; Unless there's already one there, append a '\' to end of path
	  ; entry we just moved in.

	  mov	al,'\'			;char of interest
	  dec	di			;compare vs. last one stored
	  scasb
	  .if	!zero?			;if last char was not a '\',
	    STOSB_IF_CX			;stosb and dec cx, if cx is non-zero
	  .endif
	.endif

	and	[bx].Flags,not TW_INIT	;indicate initialization phase done

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Append the user's partial path characters.

	call AppendPath

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Now extend the user's partial path with wildcard characters, as
	; necessary (e.g., if the user's entry ends with "*.*" there's
	; nothing to add; but if it ends with "xyz" then "*.*" is added; or
	; if it ends with "xy*." a single "*" is added).

	push	cx			;save remaining mask buffer space
	call SupBreak
	pop	cx			;restore remaining mask buffer space
	mov	si,dx			;si= ASCIIZ wildcard string to append
	.repeat				;append wildcard mask
	  lodsb
	  STOSB_IF_CX			;stosb and dec cx, if cx is non-zero
	.until	al == 0

	test	cx,cx			;zero status if path was unacceptable
      .until	!zero?			;loop if path was unacceptable

	pop cx
	ret

AppendPath:
	mov	si,[bx].PathPtr		;si/dx= user path start and size
	mov	dx,[bx].PathLength
	.while	dx > [bx].NameLength	;while more to append,
	  dec dx
	  lodsb				;get next user path char
	  .if al != '"' || ![bx].LFN && ![bx].SFNQuote
	    STOSB_IF_CX			;stosb and dec cx, if cx is non-zero
	  .endif
	.endw
	lea	si,[bx].NameStr
	.while dx > 0
	  dec dx
	  lodsb
	  .if al != '"' || ![bx].LFN && ![bx].SFNQuote
	    STOSB_IF_CX
	  .endif
	.endw
	ret

SupBreak:
.repeat				;dummy block (to support breaks)
	mov	dx,offset StarDotStar	;assume we'll append full '*.*'
	mov	cx,[bx].PathLength	;si/cx= end+1/size-of user entry
	jcxz	@F			;jmp= user entry empty, append '*.*'
	.repeat			;scan for '.' before ':' or '\'
	mov	al,[si-1]
	.break .if al == ':'	;break= ':', append '*.*'
	.if al == '\'
	  push di
	  call CheckSBChar
	  .if di == -1
	    pop di
	    .break		;break= '\' and not a second byte of a DBCS char
	  .endif
	  pop di
	.endif			;char, append '*.*'
	dec	si			;al= preceding char
	.if	al == '.' || [bx].LFN	;if filename separator ('.') found, or
	inc dx			;in LFN mode, discard leading '*.' portion
	inc dx
	.break
	.endif
	.untilcxz			;continue scanning if chars remain
	@@:
.until 1			;end dummy block (to support breaks)
ret

TabBuildFullPath endp

;-----------------------------------------------------------------------------
;
; End Module
;
;-----------------------------------------------------------------------------

	ENDSEG
	end
