	page	,132

;-----------------------------------------------------------------------------
;
;  This file is part of doskey.com.
; 
;  Copyright (C) 2001-2011 Paul Houle (http://paulhoule.com)
; 
;  This program is free software; you can redistribute it and/or modify
;  it under the terms of the GNU General Public License as published by
;  the Free Software Foundation; either version 2 of the License, or
;  (at your option) any later version.
; 
;  This program is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;  GNU General Public License for more details.
; 
;  You should have received a copy of the GNU General Public License
;  along with this program; if not, write to the Free Software
;  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
;
;  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; This code block must immediately follow the resident area.
;
; The block overlays what will become the start of the installed buffer
; space (/BUFSIZE=); specifically, the leading bytes of the history string
; list pool.  At some point, it initializes the history string list pool,
; which causes a single zero byte to be written directly at offset
; EndResident (corrupting the first byte of this block).
;
; Somewhere beyond offset InstallStackBase, the macro string list pool will
; be initialized.  This will overwrite startup code that follows
; InstallStackBase (somewhere, depending on the /BUFSIZE setting); so, this
; code must not call any startup routines beyond InstallStackBase.
;
;-----------------------------------------------------------------------------

	.nolist
	include	dkdefs.inc	;include constant definitions, externdef's
	.list
	option	noljmp		;disallow automatic jmp-lengthening

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

EndResident	label	near	;end of resident area

;-----------------------------------------------------------------------------
; Entry point for final TSR installation.
; si/cx= macro definition start, length (cx= 0 if none, or deletion only).

InstallTSR	label	near	;last logic executed to install new TSR

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Put as much of this code as possible at the end of this region.
	; This gives us a little extra room for the stack move that overlays
	; the history region (and may overlay this code).
	;
	; Note after the history region is set up, the first byte of the
	; below call opcode will be destroyed.

	call	StartInstall

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Set up macro string list control structure and freespace pool.
	; This causes damage somewhere beyond InstallStackBase, so no
	; calls can be made there after this point.
	;
	; Note we have to move the stack - if we're using all of the segment,
	; appending the macro will destroy the stack contents.

	mov	bx,offset slMacros	;init macro string list
	assume	bx:near ptr STRINGLIST
	mov	ax,slHistory.Next	;ax= startpoint for macro pool
	mov	[bx].Head,ax		;init start of string pool
	add	ax,cx			;add size of macro pool - initial
	inc	ax			;  definition + 1 (for terminator)
	mov	[bx].Next,ax		;init end of string pool
	mov	ax,[bx].Head		;move stack to end of history
	and	al,not 1		;(put stack on word boundary)
	xchg	sp,ax			;(put stack into history region)
	call	StringListClear		;set .Tail & .Active, store terminator
	jcxz	@F			;jmp= no initial macro definition
	  call	StringListAppend	;store initial macro
	@@:
	assume	bx:nothing

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Init CmdBuf to inactive state (this forces a user entry the first
	; time in).

	call	cbActiveDisable

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Hook into int 2f and go resident.

	mov	dx,offset MyInt2f	;set DOSKEY int 2fh vector
	mov	ax,252fh
	int	21h

	mov	dx,slMacros.Next	;terminate & stay resident
	int	27h

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

InstallStackBase	label	near	;bottom of temporary install stack

;-----------------------------------------------------------------------------
; This routine is just to get as much of the startup code as possible
; toward the end of the region, to give the temporary install stack a bit
; more space.
;
; IN:
;   si= start of new macro definition
;   cx= length of new macro definition, 0 if none or macro deletion only
; OUT:
;   si, cx= preserved

StartInstall proc near

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Release the environment block.

	push	es
	mov	es,ds:[2ch]		;release environment block
	mov	ah,49h
	int	21h
	pop	es

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Close all default handles (STDOUT, STDERR, etc).

	mov	bx,4			;close default handles
	.repeat
	  mov	ah,3eh
	  int	21h
	  dec	bx
	.until	sign?

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Set segment values of far addresses embedded in the TSR image.

	mov	ax,ds
	mov	word ptr SwStartup.sisInstanceData + 2,ax
	mov	word ptr SwiData0.iisPtr + 2,ax
	mov	word ptr SwiData1.iisPtr + 2,ax

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Set up history string list control structure and freespace pool.
	; This causes the first byte of this code block (at offset
	; EndResident) to be overwritten.

	mov	bx,offset slHistory	;init history string list
	assume	bx:near ptr STRINGLIST
	mov	ax,offset EndResident	;set history start address
	mov	[bx].Head,ax
	add	ax,SwiData1.iisSize	;set history end address
	dec	ax			;(leave 1 byte for macro terminator)
	sub	ax,cx			;(leave room for new macro definition)
	mov	[bx].Next,ax
	jmp	StringListClear		;set .Tail & .Active, store terminator
	assume	bx:nothing

StartInstall endp

;-----------------------------------------------------------------------------
;
; End Module
;
;-----------------------------------------------------------------------------

	ENDSEG
	end
