/*
	phcomp.c - Compares two file w/progress timer. 6/19/2014 PaulHoule.com

	compiled MSVC 7.1:	cl /Ox phextab.c
						(include=...;msvc\sdk\include  lib=...;msvc\sdk\lib)
	then UPX'd 3.91w:	upx phextab.exe
*/

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <dos.h>
#include <fcntl.h>
#include <string.h>
#include <memory.h>
#include <errno.h>
#include <ctype.h>
#include <windows.h>

#define ALGN 4096				// buffer alignment, and minimum buffer size

int bufsz = 16 * ALGN;			// default buffer size
char *pbf1;						// ptr to buffers
char *pbf2;
HANDLE handle1;					// handle for 1st file
HANDLE handle2;					// handle for 2nd file
__int64 pos = 0;				// current position in both files
DWORD OpenTick;					// GetTickCount() after opening files(s)
__int64 maxb;					// bytes to process (size of smallest file)

int chunk1;						// size of last chunk read from file1
int chunk2;						// size of last chunk read from file2
int chunkx;						// smallest chunk for matching

void dopenr(char *fname, HANDLE *phandle) {
	*phandle = CreateFile(fname,	// file name
		GENERIC_READ,				// open for reading
		FILE_SHARE_READ,			// share for reading
		NULL,						// default security
		OPEN_EXISTING,				// existing file only
		FILE_FLAG_NO_BUFFERING,		// don't use/alter Windows disk cache
		NULL						// no attr. template
	);
	if (*phandle != INVALID_HANDLE_VALUE) return;
	printf("*** Error %d opening '%s'\n", GetLastError(), fname);
	exit(10);
}

static void dread(char *fname, HANDLE handle, char *buf, int size, int *rsize) {
	if (ReadFile(handle, buf, size, rsize, NULL)) return;
	printf("\n*** Error %d reading '%s'\n", GetLastError(), fname);
	exit(11);
}

char *nfmt(char *pEnd, unsigned __int64 n) {
	char *pWrk = pEnd;
	int c = 3;
	*--pWrk = (char) 0;
	do {
		if (--c < 0) { *--pWrk = ','; c += 3; }
		*--pWrk = (char) ('0' + n%10);
	} while (n /= 10);
	return pWrk;
}

int memcmp__i32(char *p1, char *p2, int cnt) {
	if (cnt > 8) {						// optimize if enough data
		__int32 v1, v2;
		char *p1t = p1, *p2t = p2;
		char lstb = p1[cnt - 4];
		p1[cnt - 4] = ~p2[cnt - 4];
		do {
			v1 = *(__int32 *) p1t, p1t += 4;
			v2 = *(__int32 *) p2t, p2t += 4;
		} while (v1 == v2);
		p1t -= 4, p2t -= 4;
		p1[cnt - 4] = lstb;
		cnt -= p1t - p1;
		p1 = p1t, p2 = p2t;
	}
	if (cnt) do {						// do last handful of bytes slowly
	} while (*p1++ == *p2++ && --cnt);
	return cnt;
}

void do_one_opt(char *popt) {
	if (popt[1] == 'b' || popt[1] == 'B') {
		bufsz = atoi(&popt[2]);
		bufsz += (ALGN-1) & -bufsz;
		if (bufsz > 0) return;
	}
	if (popt[1] == '?') { printf(
		"\nCompares files w/timer display -- Ver 1.4, 2014 PaulHoule.com\n"
		"If second file not specified, first file is read and discarded.\n"
		"Bypasses operating system cache to produce consistent timings.\n"
		"\n Usage:  phcomp file1 {file2} {-?} {-bnnn}\n\n"
		"-?:    This display.\n"
		"-bnnn: Set read buffer to nnn bytes (rounded up to %d boundary).\n"
		, ALGN); exit(1);
	}
	fprintf(stderr, "bad opt: %s\n", popt); exit(99);
}

void do_opts(int *pargc, char *argv[]) {
	int i, j;
	for (i = 1; i < *pargc; i++) {
		if (argv[i][0] == '-') {
			do_one_opt(argv[i]);
			--*pargc; j = i - 1; while (++j < *pargc) argv[j] = argv[j + 1];
		}
	}
}

main(int argc, char *argv[]) {
	do_opts(&argc, argv);				// parse options, if any
	if (argc < 2) do_one_opt("-?");		// give help if no filenames

	dopenr(argv[1], &handle1);			// open 1st file
	*(DWORD *)&maxb = GetFileSize(handle1, 1 + (DWORD *) &maxb);
	if (!(pbf1 = malloc(bufsz + ALGN))) exit(20);
	pbf1 += (ALGN-1) & -(int)pbf1;
	if (argc > 2) {						// open 2nd file, if there
		__int64 f2siz;
		dopenr(argv[2], &handle2);
		*(DWORD *)&f2siz = GetFileSize(handle2, 1 + (DWORD *) &f2siz);
		if (!(pbf2 = malloc(bufsz + ALGN))) exit(20);
		pbf2 += (ALGN-1) & -(int)pbf2;
		if (maxb > f2siz) maxb = f2siz;
	}

	OpenTick = GetTickCount();			// mark time we start reading

	do {								// read and compare loop
		dread(argv[1], handle1, pbf1, bufsz, &chunk1);
		chunkx = chunk2 = chunk1;		// (in case only 1 file)

		if (argc > 2) {					// if 2nd file to process,
			dread(argv[2], handle2, pbf2, bufsz, &chunk2);

			chunkx = min(chunk1, chunk2); // smallest chunk size
			if (memcmp__i32(pbf1, pbf2, chunkx)) {	// if data doesn't match,
				char nbuf[40];
				for (chunk2 = 0; chunk2 < chunkx; chunk2++) // find mismatch
					if (pbf1[chunk2] != pbf2[chunk2]) break;
				printf("'%s' & '%s' differ at offset %s, %#2x vs %#2x\n",
					argv[1], argv[2], nfmt(&nbuf[sizeof nbuf], pos + chunk2),
					pbf1[chunk2] & 0xff, pbf2[chunk2] & 0xff);
				exit(90);
			}
		}

		pos += chunkx;					// update file position
		do {
			static int percsec = 0;
			DWORD tc = GetTickCount();
			int i = (int) ((tc - OpenTick) / 1000);
			char nbuf[40];
			if (chunkx == bufsz) {		// if haven't hit EOF
				if (i <= percsec || !isatty(fileno(stdout))) break;
			}
			percsec = i;
			i = maxb ? (int) ((pos * 1000) / maxb) : 1000;
			printf("%s ok: %s (%2d.%d%%%4d min%3d sec)%s",
				argc > 2 ? "Compared" : "Read",
				nfmt(&nbuf[sizeof nbuf], pos), i / 10, i % 10,
				percsec / 60, percsec % 60, chunkx != bufsz ? "\n" : "\r");
		} while (0);
		if (chunk1 != chunk2) {			// if files are different sizes
			printf("'%s' & '%s' are different sizes\n", argv[1], argv[2]);
			exit(30);
		}
	} while (chunkx == bufsz);			// continue until no more data
}
