/*
	phcomp.c - Compares two file w/progress timer.  PaulHoule.com

	compiled MSVC 7.1:	cl /Ox phcomp.c kernel32.lib user32.lib
						(include=...;msvc\sdk\include  lib=...;msvc\sdk\lib)
	then UPX'd 3.91w:	upx phcomp.exe

	Change Log:
		11/21/2014 Ver 1.5:	Added -o option (set starting file offset).
							Increased default bufsz x 8 (better speed).

		11/22/2014 Ver 1.6:	Allowed -o to be non-ALGN value (start anywhere).
							Added -m option (max bytes read).
							Increased default bufsz to 4096 x 4096 (16 meg).
							Replaced some C stdlib calls with equiv. WIN32.
*/

#include <stdio.h>
#include <io.h>
#include <windows.h>

#define ALGN 4096				// buffer alignment, and minimum buffer size
#define ALGN_DN(x) ((x) & ~(ALGN-1))
#define ALGN_UP(x) ALGN_DN((x) + (ALGN-1))

int bufsz = 4096 * ALGN;		// default I/O buffer size
char *pbf1;						// ptr to buffers
char *pbf2;
HANDLE handle1;					// handle for 1st file
HANDLE handle2;					// handle for 2nd file
__int64 pos = 0;				// current position in both files
int sskip = 0;					// startup compare skip (used for -o only)
__int64 mfsiz = 0x7fffffffffffffff; // file size limit (used for -m only)
DWORD OpenTick;					// GetTickCount() after opening files(s)
__int64 maxb;					// bytes to process (size of smallest file)

int chunk1;						// size of last chunk read from file1
int chunk2;						// size of last chunk read from file2
int chunkx;						// smallest chunk for matching
char wspbuf[1040];				// wsprintf() buffer

void dopenr(char *fn, HANDLE *phandle) {
	*phandle = CreateFile(fn,		// file name
		GENERIC_READ,				// open for reading
		FILE_SHARE_READ,			// share for reading
		NULL,						// default security
		OPEN_EXISTING,				// existing file only
		FILE_FLAG_NO_BUFFERING,		// don't use/alter Windows disk cache
		NULL						// no attr. template
	);
	if (*phandle != INVALID_HANDLE_VALUE) return;
	wsprintf(wspbuf, "*** Error %d opening '%s'\n", GetLastError(), fn);
	fputs(wspbuf, stdout);
	exit(10);
}

static void dread(char *fn, HANDLE handle, char *buf, int size, int *rsize) {
	int res = ReadFile(handle, buf, ALGN_UP(size), rsize, NULL);
	if (*rsize > size) *rsize = size;
	if (res) return;
	wsprintf(wspbuf, "\n*** Error %d reading '%s'\n", GetLastError(), fn);
	fputs(wspbuf, stdout);
	exit(11);
}

char *nfmt(char *pEnd, unsigned __int64 n) {
	char *pWrk = pEnd;
	int c = 3;
	*--pWrk = (char) 0;
	do {
		if (--c < 0) { *--pWrk = ','; c += 3; }
		*--pWrk = (char) ('0' + n%10);
	} while (n /= 10);
	return pWrk;
}

int memcmp__i32(char *p1, char *p2, register int cnt) {
										// fix alignment if needed
	while (p1 - (char *)0 & 0xf && cnt && *p1 == *p2) p1++, p2++, cnt--;
	while ((cnt -= 16) >= 0) {			// optimize if enough data
		if (((__int32 *)p1)[0] != ((__int32 *)p2)[0]) break;
		if (((__int32 *)p1)[1] != ((__int32 *)p2)[1]) break;
		if (((__int32 *)p1)[2] != ((__int32 *)p2)[2]) break;
		if (((__int32 *)p1)[3] != ((__int32 *)p2)[3]) break;
		p1 += 16, p2 += 16;
	}
	cnt += 16;
	if (cnt) do {						// do last handful of bytes slowly
	} while (*p1++ == *p2++ && --cnt);
	return cnt;
}

void do_one_opt(char *popt) {
	char ol = (char) CharLower((LPTSTR) (popt[1] & 0xff));
	if (ol == 'b') {
		bufsz = ALGN_UP(atoi(&popt[2]));
		if (bufsz > 0) return;
	}
	if (ol == 'o') {
		sskip = (int)(pos = _atoi64(&popt[2])) & (ALGN-1);
		if ((pos &= ~(ALGN-1)) >= 0) return;
	}
	if (ol == 'm') {
		mfsiz = _atoi64(&popt[2]);
		if (mfsiz >= 0) return;
	}
	if (ol == '?') { wsprintf(wspbuf,
		"\nCompares files w/timer -- Ver 1.6, 11/23/2014 PaulHoule.com\n"
		"If second file not specified, first file is read and discarded.\n"
		"Bypasses operating system cache to produce consistent timings.\n"
		"\n Usage:  phcomp file1 {file2} {-?} {-Bnnn} {-Onnn} {-Mnnn}\n\n"
		"-?:    This display.\n"
		"-Bnnn: Set read buffer size (default is %d).\n"
		"-Onnn: Set start file offset(s) to nnn.\n"
		"-Mnnn: Set max bytes read for file(s) to nnn.\n"
		, bufsz);
		fputs(wspbuf, stdout);
		exit(1);
	}
	wsprintf(wspbuf, "bad opt: %s\n", popt);
	fputs(wspbuf, stderr);
	exit(99);
}

void do_opts(int *pargc, char *argv[]) {
	int j = 0, i = 0;
	while (++i < *pargc) {
		if (argv[i][0] == '-') do_one_opt(argv[i]);
		else argv[++j] = argv[i];
	}
	*pargc = ++j;
}

main(int argc, char *argv[]) {
	do_opts(&argc, argv);				// parse options, if any
	if (argc < 2) do_one_opt("-?");		// give help if no filenames

	dopenr(argv[1], &handle1);			// open 1st file
	*(DWORD *)&maxb = GetFileSize(handle1, 1 + (DWORD *) &maxb);
	if (!(pbf1 = malloc(bufsz + ALGN))) exit(20);
	pbf1 = (char *) ALGN_UP(pbf1 - (char *)0);
	if (argc > 2) {						// open 2nd file, if there
		__int64 f2siz;
		dopenr(argv[2], &handle2);
		*(DWORD *)&f2siz = GetFileSize(handle2, 1 + (DWORD *) &f2siz);
		if (!(pbf2 = malloc(bufsz + ALGN))) exit(20);
		pbf2 = (char *) ALGN_UP(pbf2 - (char *)0);
		if (maxb > f2siz) maxb = f2siz;
	}
	if (maxb > mfsiz) maxb = mfsiz;		// limit size if option specified

	if (pos) {							// if -onnn specified,
		LARGE_INTEGER posli;
		posli.QuadPart = pos;
		SetFilePointerEx(handle1, posli, NULL, 0);
		if (argc > 2) SetFilePointerEx(handle2, posli, NULL, 0);
	}

	OpenTick = GetTickCount();			// mark time we start reading

	do {								// read and compare loop
		int rdsz = 0;					// assume nothing to read
		__int64 mf = mfsiz - pos;		// bytes left per mfsiz limit
		if (mf >= 0) {					// if something left per mfsiz,
			rdsz = bufsz;				// limit to mfsiz max, if needed
			if (mf < rdsz) rdsz = (int) mf;
		}
		dread(argv[1], handle1, pbf1, rdsz, &chunk1);
		chunkx = chunk2 = chunk1;		// (in case only 1 file)

		if (argc > 2) {					// if 2nd file to process,
			int i;
			dread(argv[2], handle2, pbf2, rdsz, &chunk2);

			chunkx = min(chunk1, chunk2); // smallest chunk size

			if (chunkx > sskip) {		// if something to compare,
				if (i = memcmp__i32(	// if mismatch,
				  pbf1 + sskip, pbf2 + sskip, chunkx - sskip)) {
					char nbuf[40];
					i = chunkx - i;
					wsprintf(wspbuf, 
						"'%s' & '%s' differ at offset %s, %#2x vs %#2x\n",
						argv[1], argv[2], nfmt(&nbuf[sizeof nbuf], pos + i),
						pbf1[i] & 0xff, pbf2[i] & 0xff);
					fputs(wspbuf, stdout);
					exit(90);
				}
			}
			if ((sskip -= chunkx) < 0) sskip = 0;
		}

		pos += chunkx;					// update file position
		do {
			static int percsec = 0;
			DWORD tc = GetTickCount();
			int i = (int) ((tc - OpenTick) / 1000);
			char nbuf[40];
			if (chunkx == bufsz) {		// if haven't hit EOF
				if (i <= percsec || !isatty(fileno(stdout))) break;
			}
			percsec = i;
			i = maxb ? (int) ((pos * 1000) / maxb) : 1000;
			wsprintf(wspbuf, 
				"%s ok: %s (%2d.%d%%%4d min%3d sec)%s",
				argc > 2 ? "Compared" : "Read",
				nfmt(&nbuf[sizeof nbuf], pos), i / 10, i % 10,
				percsec / 60, percsec % 60, chunkx != bufsz ? "\n" : "\r");
			fputs(wspbuf, stdout);
		} while (0);
		if (chunk1 != chunk2) {			// if files are different sizes
			wsprintf(wspbuf, 
				"'%s' & '%s' are different sizes\n", argv[1], argv[2]);
			fputs(wspbuf, stdout);
			exit(30);
		}
	} while (chunkx == bufsz);			// continue until no more data
}
