;-----------------------------------------------------------------------------
;
;	PHEcho			Paul Houle (paulhoule.com)	5/4/2005
;
; Echoes command line to stdout device, after mapping some defined escape
; sequences.  For example,
;
;	C>phecho this\d\ais\x0d\x0aa test
;
; Will display "this(cr,lf)is(cr,lf)a test".
;
; May also be used in config.sys via device=phecho.com, i.e.
;
;	device=phecho.com this\d\ais\x0d\x0aa test
;
; (No device is installed, just the display is performed).
; Note: running via device= causes text to be converted to lowercase --
; this is unavoidable; DOS destroys the case before passing the argument.
; So, in config.sys only, we map a !x source pair to an uppercase X.
;
;
; If used with no arguments from the command line, help is given.
;
;
; This is intended for DOS boot disks.  It is a tiny (< 512 bytes, a single
; sector) program suited for a boot floppy and an old version of DOS.
;
;-----------------------------------------------------------------------------

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Set up .com environment.  Note: because of the way we implement
	; config.sys execution the value of cs and ss cannot be assumed --
	; translation: careful not to use either implicitly or explicitly.

code	segment
	assume	ds:code,es:code,cs:nothing,ss:nothing
	org	100h			;.com file org
start	label	near

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; The below is needed only to support config.sys execution.

	jmp short $+10
	db	8 dup (?)

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Convert arg string to ASCIIZ (terminate w/0).
	; Set si to point to string start, and call the main logic.
	; Finally, exit to DOS.

	mov	si,80h			;si= command argument string
	lodsb				;bx= argument length
	cbw
	xchg	bx,ax
	mov	byte ptr [si+bx],bh	;terminate arg string w/0

	call	main			;execute the main logic

	mov	ax,4c00h		;return to DOS
	int	21h

;-----------------------------------------------------------------------------
;
; Main logic -- this routine is called from either entry (execution via
; command line, or using "device=" in config.sys.
;
; IN:	ds:si= ASCIIZ argument string
;	es=ds
;	cs,ss= unknown, preserved
;	bp= may not be used!  (not saved by device= shell logic)
;
;-----------------------------------------------------------------------------

main	proc	near

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Skip leading whitespace (space/tab).  Give help if there is nothing
	; but whitespace.
	;
	; Note: if called via config.sys the helpmsg is empty (it's used as
	; a buffer), so nothing is displayed.

	.repeat

	  lodsb
	  .if	al == 0			;if nothing to echo,
	    mov	si,offset helpmsg + 1	;cause display of our helpmsg (+ 1
	  .endif			;  to offset the below dec si)
	.until	al != ' ' && al != 09h
	dec	si			;restore non-whitespace we stopped on

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Main loop to process escape sequences.

	.repeat

	  lodsb				;fetch next char
	  .break .if al == 0		;hit end, exit

	  .if	al == '\'		;if start of sequence,
	    .break .if byte ptr [si] == 0 ;ignore if at end

	    call fetchex		;see if hex digit follows
	    .if  !carry?		;if yes,

	      xchg bx,ax		;bx= 2nd digit (if one exists)
	      call fetchex
	      xchg bx,ax
	      .if  !carry?		;if got a good 2nd digit,
		mov cl,4		;include 2nd digit
		shl al,cl
		or  al,bl
	      .endif

	    .else

	      lodsb			;get 2nd of pair
	      .if al >= 'a'		;don't futz with \
		and  al,not 20h		;convert to uppercase
	      .endif
	      mov di,offset bpair
	      mov cx,bpair2 - bpair
	      repne scasb
	      .continue .if !zero?	;ignore pair if 2nd char not found
	      mov al,(bpair2 - bpair)[di-1] ;map to replacement char

	    .endif
	  .endif

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Display char.  We go through a tad more work to use function 40h,
	; so that output redirected to a file isn't altered, as function
	; 02h does (for instance, re-directed tabs turn into spaces).
	;
	; Function 40h isn't supposed to be available from config.sys, yet it
	; works fine (at least with the stdout handle) with all the versions
	; of DOS that I tried (back to 3.1).  To be correct we should case it
	; out and use 02h if running from config.sys, and 40h only if running
	; from the command line.

	  mov	[helpmsg],al		;(helpmsg is no longer needed)
	  mov	dx,offset helpmsg
	  mov	bx,1
	  mov	cx,bx			;output 1 char to handle 1 (stdout)
	  mov	ah,40h
	  int	21h

	.until	0

	ret
main	endp

;-----------------------------------------------------------------------------
;
; Fetch hex digit from ds:si.
;
; If ds:[si] is not a valid hex digit, exit w/carry (si is unchanged).
; Otherwise al = hex digit (0..f), si advanced by 1.
;
;-----------------------------------------------------------------------------

fetchex	proc	near
	lodsb

	cmp	al,'0'			;below 0 is illegal
	jc	derr
	cmp	al,'9'
	jbe	dok			;jmp= in range 0..9

	or	al,20h			;convert letter to lowercase
	.if	al < 'a' || al > 'f'	;if not a valid hex letter,
derr:	  mov	al,'a' - ('9' + 1)	;cause a carry on exit
	  dec	si			;unprocess source char
	.endif
	sub	al,'a' - ('9' + 1)	;remove gap between '9' and 'a'

dok:	sub	al,'0'			;create valid hex

	ret
fetchex	endp

;-----------------------------------------------------------------------------
;
; Recognized 2nd char of sequences.  bpair is 2nd char of source pair,
; bpair2 is vector of replacement values.
;
;-----------------------------------------------------------------------------

bpair	db	'\','Q','G','L','I','N','M'
bpair2	db	'\','=','>','<','|','^','&'

;-----------------------------------------------------------------------------
;
; Help message issued when executed from the command line with a blank
; argument.
;
; Note: when run from config.sys the help message is used as a buffer to
; hold the argument line (to create a ds: copy of it).
;
;-----------------------------------------------------------------------------

helpmsg	db  13,10
	db  'Echoes argument to console, ver 1.0.'
	db  '  Paul Houle (paulhoule.com).',13,10
	db  'Runs as command or in config.sys via "device=".',13,10
	db  13,10,'mappings:',13,10,13,10
	db  '   \\ +'
	db  9,'\\:\\',9,'Q:=',9,'G:>',9,'L:<',9,'I:|',9,'n:^',13,10
	db  9,'M:&',9,'hex(1 or 2): ASCII char',13,10
	db  13,10,'config.sys only:',13,10,13,10
	db  '   ! +',9,'?: uppercase ?',13,10
	db	0
helpend	equ $

;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------
;
; Below this point is the logic we use to allow operation from within
; config.sys as a "device=" call.  No device is installed, we just format
; and output the portion of the line beyond the device name.
;
; The approach used is to simulate a tiny model as closely as possible.
; We copy the FAR argument string to near memory, overwriting the helpmsg.
; Then we futz with es and ds to simulate a .com environment.  cs and ss we
; don't bother with (we could, but the shared code doesn't require it).
;
; Note: the source is is org'd for .com (100h)... drivers run org'd at 0.
; We get around that in most places by adjusting segment registers to
; simulate .com, but where we can't, you'll see (- 100h) on addresses.
;
;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------
;-----------------------------------------------------------------------------

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Overlay a device header we need at the start of the image.

dvstart	label	near
	org	102h		;org to dev hdr fields we need to fill in
	dw	0		;segment of link field (offset is a short jmp)
attrib	dw	0		;(block device)
strat	dw	pstrat - 100h	;org 0 offsets to strategy
inter	dw	pinter - 100h	;  and interrupt routines
	org	dvstart

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Strategy routine -- supposed to store a ptr to the request header.
	; Since es & bx are preserved (in all versions of DOS I found) across
	; the init call strat & int calls, we do nothing here to save space.
if 0
pstrat	label	far
	mov	word ptr cs:[mvbxop - 100h + 1],bx
	mov	word ptr cs:[mvdsop - 100h + 1],es
	retf
endif
	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Interrupt routine -- treat anything as INIT.  That works
	; since INIT is the first and only call we'll get.

pinter	label	far
	push	ds
	push	es
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Load the request header address.
	;
	; Do necessary request header stuff for a failed init call.
	;
	; Get ds:si pointing to config.sys arg line (all we need).

	push	es
	pop	ds

if 0					;see "Strategy routine" section above
mvdsop:	mov	bx,1234
	mov	ds,bx
mvbxop:	mov	bx,5678
endif

	mov	word ptr [bx+3],8100h	;set status: error+done bits true
	and	word ptr [bx+14],0	;end address = start address
	mov	word ptr [bx+16],cs
	lds	si,[bx+18]		;ds:si= config.sys line after device=

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Set es to the "tiny" model equivalent.  With es we can use the
	; natural offsets the code compiles to.

	mov	ax,cs			;es= valid for .com based addressing
	sub	ax,10h			;  (shared main code needs this)
	mov	es,ax

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Copy config.sys arguments over the helpmsg buffer.  This is so we
	; can address it in the tiny model shared code (the config.sys line
	; comes to us in a far buffer).
	;
	; Note: we actually build the copy at helpmsg + 1.  The byte
	; directly at helpmsg is zeroed to create an empty help message.
	;
	; Note: DOS's config.sys logic has the annoying habit of capitalizing
	; the entire command tail, so case is lost.  Lower case is preferable,
	; so we convert to lowercase here, unless the preceding character is
	; a '!' -- if so we map the pair to uppercase (e.g.  !a == A).

	mov	di,offset helpmsg	;es:di= helpmsg buffer

	mov	al,0			;create an empty helpmsg (help
	stosb				;  displays nothing in config.sys)

	push	di			;save start of copy buffer

	.repeat				;copy data, removing device name
	  lodsb
	  .break .if al == 0dh || al == 0ah
	  .if al >= 'A' && al <= 'Z'
	    dec di
	    .if byte ptr es:[di] != '!'
	      inc di
	      add al,'a' - 'A'
	    .endif
	  .endif
	  .if di != offset helpmsg + 1 || al == ' ' || al == 09h
	    stosb
	  .endif
	.until	di >= offset helpend	;stop if helpmsg buffer is full

	mov	al,0			;terminate (create an ASCIIZ string)
	stosb

	pop	si			;set entry si for main code

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Set final ".COM-like" environment by setting ds = es.

	push	es
	pop	ds

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Run the shared main code.

	call	main

	;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	; Return from device init.  First we must set the link offset to
	; 0ffffh so DOS won't look for any more drivers in our image.

	or	word ptr start,-1

	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	es
	pop	ds
pstrat	label	far
	retf

code	ends
	end	start
