/*
	phextab.c - replaces tabs with strings of spaces. 4/27/2014 PaulHoule.com

	compiled MSVC 7.1:	cl /Ox phextab.c
	then UPX'd 3.91w:	upx phextab.exe
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef _WIN32
  #include <io.h>
  #include <fcntl.h>
#endif

int tstop = 8;					// default tab stop setting
int rcol;						// cols to next tab stop

char inbuf[16384];				// input file buffer
char *iptr = inbuf + sizeof(inbuf); // next input byte to process
char * const iend = inbuf + sizeof(inbuf);

char outbuf[16384];				// output file buffer
char *optr = outbuf;			// next output byte to write
char * const oend = outbuf + sizeof(outbuf);

static void emsg(char *t1) {	// display stderr msg & exit w/err
	fputs("phextab: ", stderr);
	fputs(t1, stderr); fputs("\n", stderr);
	exit(1);
}

static void untab(void) {				// this is where all the work is done
	char *ip = iptr;					// get vars into registers
	char *op = optr;
	int rc = rcol;

	while (ip < iend && op < oend) {	// while input data & output space,
		char c = *ip++;
		if (c == '\t') {
			for (;;) {
				*op++ = ' ';			// store a space
				if (--rc == 0) break;	// done if we're at a tab stop
				if (op < oend) continue; // continue if more output space
				--ip;					// else restart tab next time in
				break;
			}
			if (rc) break;				// break= output full
			rc = tstop;					// reset rc and continue
			continue;
		}
		*op++ = c;
		if (c == '\r' || c == '\n' || --rc == 0) {
			rc = tstop;
		}
	}

	rcol = rc;							// update memory copies of vars
	optr = op;
	iptr = ip;
}

main(int argc, char **argv) {
	if (isatty(fileno(stdin))) {
		fputs("\nReplaces tabs with strings of spaces -- Ver 2.1, "
			"2014 PaulHoule.com\n\n"
			" USAGE:  phextab {tab} <infile >outfile\n\n"
			"{tab}:   tab stop setting (default is 8)\n", stdout);
		exit(1);
	}

	if (argc >= 2) {					// parse tab stop arg, if there
		char *eptr;
		long ts = strtol(argv[1], &eptr, 10);
		if (*eptr || ts <= 0 || ts >= 10000) {
			emsg("Illegal tab stop");
		}
		tstop = (int) ts;
	}

	#ifdef _WIN32
		setmode(fileno(stdin), O_BINARY);
		setmode(fileno(stdout), O_BINARY);
	#endif

	rcol = tstop;						// init residual cols to tab stop size
	for (;;) {
		if (iptr == iend) {				// if more input needed,
			int rdb = fread(iptr = inbuf, 1, sizeof(inbuf), stdin);
			if (rdb < sizeof(inbuf)) {	// if didn't get a full buffer,
				if (ferror(stdin)) {	// abort if due to error
					emsg("Error reading");
				}
				memmove(iptr = iend - rdb, inbuf, rdb); // move data to end
			}
		}

		untab();						// process as much source as we can

		if (optr == oend || iptr == iend) { // if out full, or time to flush,
			int wrb = optr - outbuf;	// bytes to write
			if (wrb == 0) break;		// exit if no input or output left
			if (wrb != fwrite(optr = outbuf, 1, wrb, stdout)) {
				emsg("Error writing");
			}
		}
	}
}
