/*----------------------------------------------------------------------------
;
; X86 MD5 test routine 1.1 -- Paul Houle (paulhoule.com) 4/14/2010
;
; Command-line test of phmd5 MD5 generation code.
; Compiled with Microsoft C 7.1 (Ver 13.10.3077):
;
;	cl dophmd5.c phmd5.obj phmd5a.obj
;
;---------------------------------------------------------------------------*/

#include <stdio.h>
#include "phmd5.h"

// File read buffer.
// buf should be big enough to reduce fread/looping overhead.
// Too big hurts due to cache overflow problems.
// 128k is optimal on tested system, but shrinking it to as small as 4k
// only reduces overall performance 5% or so.
char buf[128 * 1024];					// file read buffer

int main(int argc, char *argv[]) {
	PHMD5 phmd5;						// MD5 work structure
	FILE *inf;							// input file handle
	unsigned fsz;						// size of last input block

	if (argc < 2) {						// give help if no filename arg
		printf(
		"\nX86 MD5 test, ver 1.1.  (c) 4/14/2010, PaulHoule.com\n\n"
		"    usage: dophmd5 filename\n"
		);
		return 1;
	}

	inf = fopen(argv[1], "rb");			// open file for reading, binary mode
	if (inf == NULL) {
		printf("Can't open file: %s\n", argv[1]);
		return 1;
	}

	Phmd5Begin(&phmd5);					// initiate the MD5 session

	do {
										// read a block of input
		fsz = fread(buf, 1, sizeof(buf), inf);
		Phmd5Process(&phmd5, buf, fsz);	// process input block
	} while (fsz == sizeof(buf));

	Phmd5End(&phmd5);					// finalize the MD5 hash
	fclose(inf);

	for (fsz = 0; fsz < 16; fsz++) {	// display final hash
		printf("%02X", phmd5.hash[fsz]);
	}
	printf("\n");
}
