/*----------------------------------------------------------------------------
;
; X86 MD5 hash generator -- Paul Houle (paulhoule.com) 4/14/2010
;
; This code is in the public domain.  Please attribute the author.
;
; There are a lot of MD5 generators; here's another.  This one is targeted
; for X86 only (little-endian memory architecture).  The benefit of this is
; speed -- bytes within larger elements do not need to be rotated.
;
; Currently there's a 32-bit premise, so the unsigned type is assumed 32-bit.
;
; Though other compilers might be usable, this was developed using
; Microsoft C 7.1 (Ver 13.10.3077).
;
;	cl /c /Oax phmd5.c
;	cl /c /Oax phmd5a.c
;
; Link the resulting .obj's into your executable and #include "phmd5.h"
;
; How to call the routines to generate a hash:
;
;	(1) Allocate a PHMD5 type struct -- it's small, can be static or local.
;		A pointer to this struct is the first argument to all functions.
;
;	(2) Call Phmd5Begin() once -- this initializes the PHMD5 struct.
;
;	(3) Call Phmd5Process() as many times as necessary for all data
;		to be included in the MD5 hash.
;
;	(4) Call Phmd5End() once.  The final 16-byte MD5 hash will then be
;		available in PHMD5->hash.  Note the finished hash is a simple array
;		of bytes, and must be treated/displayed/copied/etc that way.
;
; For best performance the Phmd5Process() "pdata" pointer should be 32-bit
; aligned (a multiple of 4) and "bytecnt" should be a multiple of 64.
; As long as both of these conditions continue to be met the input data is
; processed in-place; otherwise, some speed (10-15%) is lost as the data
; must be copied to an internal blocking buffer before being proceessed.
;
;---------------------------------------------------------------------------*/

typedef struct {
	unsigned char hash[16];				// final 16-byte hash winds up here
	unsigned totbyt[2];					// processed byte count
	char buf[64];						// input blocking buffer
} PHMD5;

void Phmd5Begin(PHMD5 *pmd5);
void Phmd5Process(PHMD5 *pmd5, char *pdata, unsigned bytecnt);
void Phmd5End(PHMD5 *pmd5);
