/*
	Issue prompt, get user input line w/o echo.  June 26, 2014

	This is to prompt-for/enter a password, without echoing keystrokes
	(if we didn't care about echo, we could simply do  SET /P pw=prompt).

	compiled MSVC 7.1:	cl /Ox phprompt.c
	then UPX'd 3.91w:	upx phprompt.exe
*/

#include <stdio.h>
#include <stdlib.h>

main(int argc, char **argv) {
	char inbuf[256];
	char *pib;

	if (argc < 2) { fputs(
		"\nPrompts for non-echoed user input -- Ver 1.0, 2014 PaulHoule.com\n"
		"\nA prompt is written to the stderr device, then the user enters\n"
		"a line of input via stdin (not echoed as it is keyed).  Upon\n"
		"completion, the entire user input line is written to stdout.\n"
		"\nCould be used in a batch file something like this:\n"
		"  for /f \"delims=\" %%p in ('phprompt \"PW? \"') do set pw=%%p\n\n"
		" Usage:  phprompt text\n\n"
		"text:  Prompt written to stderr, eg: \"Enter password: \""
		"\n", stdout); exit(1);
	}
	fputs(argv[1], stderr);				// output prompt
	pib = inbuf;
	do {
		int c = getch();
		if (c == 0 || c == 0xe0) {
			getch();					// discard 2-char special sequences
			c = 0;						// cause "bad char" beep
		}
		if (c == '\x03') exit(2);		// exit w/error if ctl+c
		if (c == '\b') {				// handle backspace
			if (pib != &inbuf[0]) {
				pib--;
				continue;
			}
			c = 0;						// error if backspace at left margin
		}
		if (c == '\r') break;			// handle enter
		if (pib == &inbuf[sizeof inbuf - 2]) { // handle buffer full
			c = 0;
		}
		if (c < 0x20 || c > 0x7e) {		// beep/ignore if error/non-printable
			fputc('\a', stderr);
			continue;
		}
		*pib++ = (char) c;
	} while (1);
	pib[0] = '\n';						// terminate user input string
	pib[1] = '\0';
	fputs(inbuf, stdout);				// output user entry
}
